/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.decoration.Motive;
import subaraki.paintings.Paintings;
import subaraki.paintings.gui.IPaintingGUI;
import subaraki.paintings.gui.PaintingButton;
import subaraki.paintings.utils.CommonConfig;

public class CommonPaintingScreen
extends Screen
implements IPaintingGUI {
    public static final int START_X = 10;
    public static final int START_Y = 30;
    public static final int GAP = 5;
    private final int entityID;
    private final Button defaultButton = new Button(0, 0, 0, 0, (Component)new TextComponent("default"), button -> {});
    private final Motive[] types;
    private int scrollBarScroll = 0;

    public CommonPaintingScreen(Motive[] types, int entityID) {
        super((Component)new TranslatableComponent("select.a.painting"));
        this.types = types;
        this.entityID = entityID;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButtons();
        this.scrollBarScroll = 0;
    }

    private void addButtons() {
        int END_X = this.f_96543_ - 30;
        int prevHeight = this.types[0].m_31901_();
        int posx = 10;
        int posy = 35;
        int index = 0;
        int rowstart = 0;
        for (Motive motive : this.types) {
            if (posx + motive.m_31896_() > END_X || prevHeight > motive.m_31901_()) {
                this.centerRow(rowstart, index - 1);
                rowstart = index;
                posx = 10;
                posy += prevHeight + 5;
                prevHeight = motive.m_31901_();
            }
            try {
                this.m_142416_((GuiEventListener)new PaintingButton(posx, posy, motive.m_31896_(), motive.m_31901_(), (Component)new TextComponent(""), button -> {
                    this.sendPacket(motive, this.entityID);
                    this.m_7861_();
                    this.m_7379_();
                }, motive));
            }
            catch (NullPointerException e) {
                Paintings.LOGGER.warn("*******************");
                Paintings.LOGGER.warn(e.getMessage());
                Paintings.LOGGER.warn("*******************");
            }
            posx += 5 + motive.m_31896_();
            ++index;
        }
        this.centerRow(rowstart, this.getRenderablesWithCast().size() - 1);
    }

    private void centerRow(int start, int end) {
        if (this.optionalAbstractWidget(start).isPresent() && this.optionalAbstractWidget(end).isPresent()) {
            int left = this.optionalAbstractWidget((int)start).get().f_93620_;
            int right = this.optionalAbstractWidget((int)end).get().f_93620_ + this.optionalAbstractWidget(end).get().m_5711_();
            int correction = (this.f_96543_ - 20 - (right - left)) / 2;
            for (int i = start; i <= end; ++i) {
                this.optionalAbstractWidget(i).ifPresent(widget -> {
                    if (widget instanceof PaintingButton) {
                        PaintingButton painting = (PaintingButton)((Object)widget);
                        painting.shiftX(correction);
                    }
                });
            }
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float f) {
        this.m_7333_(stack);
        CommonPaintingScreen.m_93172_((PoseStack)stack, (int)10, (int)30, (int)(this.f_96543_ - 10), (int)(this.f_96544_ - 30), (int)0x44444444);
        Window window = this.f_96541_.m_91268_();
        int scale = (int)window.m_85449_();
        RenderSystem.m_69488_((int)(10 * scale), (int)(30 * scale), (int)(this.f_96543_ * scale), (int)((this.f_96544_ - 60) * scale));
        super.m_6305_(stack, mouseX, mouseY, f);
        RenderSystem.m_69471_();
        if (!this.getRenderablesWithCast().isEmpty()) {
            this.drawFakeScrollBar(stack);
        }
        CommonPaintingScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        this.drawToolTips(stack, mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double mouseScroll) {
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            int foreseeBottomLimit = this.optionalLastWidget().get().f_93621_ + this.optionalLastWidget().get().m_93694_() + 16;
            int bottomLimit = this.f_96544_ - 30 - this.optionalLastWidget().get().m_93694_();
            int foreseeTopLimit = this.optionalFirstWidget().get().f_93621_ + 16;
            int topLimit = 35;
            if (mouseScroll < 0.0 && foreseeBottomLimit < bottomLimit) {
                return super.m_6050_(mouseX, mouseY, mouseScroll);
            }
            if (mouseScroll > 0.0 && foreseeTopLimit > topLimit) {
                return super.m_6050_(mouseX, mouseY, mouseScroll);
            }
            this.move(mouseScroll);
        }
        return super.m_6050_(mouseX, mouseY, mouseScroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int buttonID, double amountX, double amountY) {
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            amountY *= -1.0;
            int foreseeBottomLimit = (int)((double)(this.optionalLastWidget().get().f_93621_ + this.optionalLastWidget().get().m_93694_()) + (amountY /= 2.0) * 16.0);
            int bottomLimit = this.f_96544_ - 30 - this.optionalLastWidget().get().m_93694_();
            int foreseeTopLimit = (int)((double)this.optionalFirstWidget().get().f_93621_ + amountY * 16.0);
            int topLimit = 35;
            if (amountY < 0.0 && foreseeBottomLimit < bottomLimit) {
                return super.m_7979_(mouseX, mouseY, buttonID, amountX, amountY);
            }
            if (amountY > 0.0 && foreseeTopLimit > topLimit) {
                return super.m_7979_(mouseX, mouseY, buttonID, amountX, amountY);
            }
            this.move(amountY);
        }
        return super.m_7979_(mouseX, mouseY, buttonID, amountX, amountY);
    }

    private void move(double scroll) {
        this.scrollBarScroll = (int)((double)this.scrollBarScroll - scroll * 16.0);
        for (Widget w : this.getRenderablesWithCast()) {
            if (!(w instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)w;
            widget.f_93621_ = (int)((double)widget.f_93621_ + scroll * 16.0);
        }
    }

    private void drawToolTips(PoseStack mat, int mouseX, int mouseY) {
        if (!CommonConfig.show_painting_size) {
            return;
        }
        for (Widget guiButton : this.getRenderablesWithCast()) {
            PaintingButton button;
            if (!(guiButton instanceof PaintingButton) || !(button = (PaintingButton)guiButton).m_5953_(mouseX, mouseY)) continue;
            TextComponent text = new TextComponent(button.m_5711_() / 16 + "x" + button.m_93694_() / 16);
            HoverEvent hover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)text);
            Style style = Style.f_131099_.m_131144_(hover);
            this.m_96570_(mat, style, this.f_96543_ / 2 - this.f_96547_.m_92895_(text.m_6111_()) - 4, this.f_96544_ - 7);
        }
    }

    private void drawFakeScrollBar(PoseStack mat) {
        if (this.getRenderablesWithCast().isEmpty()) {
            return;
        }
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            int top = this.optionalFirstWidget().get().f_93621_;
            float containerSize = this.f_96544_ - 60;
            int bot = this.optionalLastWidget().get().f_93621_ + this.optionalLastWidget().get().m_93694_();
            float totalSize = bot - top + 5;
            float percent = containerSize / totalSize * 100.0f;
            if (percent < 100.0f) {
                float sizeBar = containerSize / 100.0f * percent;
                float relativeScroll = (float)this.scrollBarScroll / 100.0f * percent;
                this.m_93179_(mat, this.f_96543_ - 10, 30, this.f_96543_, 30 + (int)containerSize, Integer.MIN_VALUE, -2145246686);
                this.m_93179_(mat, this.f_96543_ - 10, 30 + (int)relativeScroll, this.f_96543_, 30 + (int)relativeScroll + (int)sizeBar, -2130706433, -2145246686);
            }
        }
    }

    private Optional<AbstractWidget> optionalFirstWidget() {
        return this.optionalAbstractWidget(0);
    }

    private Optional<AbstractWidget> optionalLastWidget() {
        return this.optionalAbstractWidget(this.getRenderablesWithCast().size() - 1);
    }

    @Override
    public Optional<AbstractWidget> optionalAbstractWidget(int index) {
        return Optional.empty();
    }

    @Override
    public List<Widget> getRenderablesWithCast() {
        throw new RuntimeException("painting gui common code crash override. please override paintingscreen");
    }

    @Override
    public void sendPacket(Motive motive, int entityID) {
    }
}

