/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod;

import net.minecraft.ResourceLocationException;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import subaraki.paintings.mod.ConfigData;
import subaraki.paintings.network.NetworkHandler;
import subaraki.paintings.utils.PaintingEntry;
import subaraki.paintings.utils.PaintingPackReader;

@Mod(value="paintings")
@Mod.EventBusSubscriber(modid="paintings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Paintings {
    public Paintings() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::modConfig);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigData.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigData.CLIENT_SPEC);
    }

    @SubscribeEvent
    public static void registerPaintings(RegistryEvent.Register<Motive> event) {
        for (PaintingEntry entry : PaintingPackReader.addedPaintings) {
            try {
                Motive painting = (Motive)new Motive(entry.getSizeX(), entry.getSizeY()).setRegistryName("paintings", entry.getRefName());
                event.getRegistry().register((IForgeRegistryEntry)painting);
            }
            catch (ResourceLocationException e) {
                subaraki.paintings.Paintings.LOGGER.error("Skipping. Found Error: {}", (Object)e.getMessage());
            }
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        new NetworkHandler();
    }

    public void modConfig(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigData.CLIENT_SPEC) {
            ConfigData.refreshClient();
        } else if (config.getSpec() == ConfigData.SERVER_SPEC) {
            ConfigData.refreshServer();
        }
    }

    static {
        new PaintingPackReader().init();
    }
}

