/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.network.client;

import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraftforge.network.NetworkEvent;
import subaraki.paintings.gui.PaintingScreen;
import subaraki.paintings.network.IPacketBase;
import subaraki.paintings.network.NetworkHandler;
import subaraki.paintings.network.ProcessClientPacket;

public class CPacketPainting
implements IPacketBase {
    private int entityID;
    private String[] resLocNames;

    public CPacketPainting() {
    }

    public CPacketPainting(Painting painting, ResourceLocation[] resLocs) {
        this.entityID = painting.m_19879_();
        this.resLocNames = (String[])Arrays.stream(resLocs).map(ResourceLocation::toString).toArray(String[]::new);
    }

    public CPacketPainting(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.resLocNames.length);
        Arrays.stream(this.resLocNames).forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130070_(arg_0));
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.resLocNames = new String[buf.readInt()];
        for (int i = 0; i < this.resLocNames.length; ++i) {
            this.resLocNames[i] = buf.m_130277_();
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ProcessClientPacket.handle(this.entityID, this.resLocNames, PaintingScreen::new));
        context.get().setPacketHandled(true);
    }

    @Override
    public void encrypt(int id) {
        NetworkHandler.NETWORK.registerMessage(id, CPacketPainting.class, CPacketPainting::encode, CPacketPainting::new, CPacketPainting::handle);
    }
}

