/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.epsilon;

import com.alcatrazescapee.notreepunching.epsilon.Spec;
import com.alcatrazescapee.notreepunching.epsilon.TomlUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableBoolean;

public final class EpsilonUtil {
    public static void parse(Spec spec, Path path, Consumer<String> onError) {
        EpsilonUtil.parse(spec, path, onError, () -> EpsilonUtil.write(spec, path, onError));
    }

    public static void parse(Spec spec, Path path, Consumer<String> onError, Runnable onWrite) {
        String text;
        spec.parseDefaults();
        if (Files.notExists(path, new LinkOption[0])) {
            onWrite.run();
            return;
        }
        try {
            text = Files.readString(path);
        }
        catch (IOException e2) {
            onError.accept("Unable to read file: '%s': %s".formatted(path, e2));
            return;
        }
        TomlUtil.TomlParseResult result = TomlUtil.parse(text);
        MutableBoolean errors = new MutableBoolean(result.errors());
        Map<String, Object> data = result.map();
        spec.parse(data, e -> {
            errors.setTrue();
            onError.accept((String)e);
        });
        if (errors.booleanValue()) {
            onWrite.run();
        }
    }

    public static void write(Spec spec, Path path, Consumer<String> onError) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            spec.write(writer::write);
        }
        catch (IOException e) {
            onError.accept("Error writing file: '%s': %s".formatted(path, e));
        }
    }
}

