/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.epsilon;

import com.alcatrazescapee.notreepunching.epsilon.ParseError;
import com.alcatrazescapee.notreepunching.epsilon.ValueConverter;
import com.alcatrazescapee.notreepunching.epsilon.value.TypeValue;
import com.alcatrazescapee.notreepunching.epsilon.value.Value;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Type<T> {
    public static final Type<Boolean> BOOL = Type::asBool;
    public static final Type<Integer> INT = Type::asInt;
    public static final Type<Float> FLOAT = Type::asFloat;
    public static final Type<String> STRING = Type::asString;
    public static final Type<List<String>> STRING_LIST = t -> Type.asList(t, Type::asString);

    public static boolean asBool(Object token) throws ParseError {
        if (token instanceof Boolean) {
            Boolean boolValue = (Boolean)token;
            return boolValue;
        }
        throw new ParseError("Cannot convert " + token + " to boolean");
    }

    public static int asInt(Object value) throws ParseError {
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            return intValue;
        }
        throw new ParseError("Cannot convert " + value + " to int");
    }

    public static float asFloat(Object value) throws ParseError {
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return floatValue.floatValue();
        }
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            return intValue.intValue();
        }
        throw new ParseError("Cannot convert " + value + " to float");
    }

    public static String asString(Object value) throws ParseError {
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        throw new ParseError("Cannot convert " + value + " to string");
    }

    public static <T> List<T> asList(Object token, Function<Object, T> element) throws ParseError {
        if (token instanceof List) {
            List value = (List)token;
            return value.stream().map(element).toList();
        }
        throw new ParseError("Cannot convert " + token + " to list");
    }

    public T parse(Object var1);

    default public <V extends Value<T>> ValueConverter<T, T, V> map(Function<T, V> factory) {
        return this.map(Function.identity(), Function.identity(), factory);
    }

    default public <V extends Value<T>> ValueConverter<T, T, V> map(Consumer<T> parseFunction, Function<T, V> factory) {
        return this.map(t -> {
            parseFunction.accept(t);
            return t;
        }, Function.identity(), factory);
    }

    default public <U> ValueConverter<T, U, TypeValue<U>> map(Function<T, U> parseFunction, Function<U, T> writeFunction) {
        return this.map(parseFunction, writeFunction, TypeValue::new);
    }

    default public <U, V extends Value<U>> ValueConverter<T, U, V> map(Function<T, U> parseFunction, Function<U, T> writeFunction, Function<U, V> factory) {
        return new ValueConverter<T, U, V>(this, parseFunction, writeFunction, factory);
    }
}

