/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.client;

import com.alcatrazescapee.primalwinter.blocks.PrimalWinterBlocks;
import com.alcatrazescapee.primalwinter.client.PrimalWinterAmbience;
import com.alcatrazescapee.primalwinter.client.SnowParticle;
import com.alcatrazescapee.primalwinter.platform.client.BlockColorCallback;
import com.alcatrazescapee.primalwinter.platform.client.FogColorCallback;
import com.alcatrazescapee.primalwinter.platform.client.FogDensityCallback;
import com.alcatrazescapee.primalwinter.platform.client.ItemColorCallback;
import com.alcatrazescapee.primalwinter.platform.client.ParticleProviderCallback;
import com.alcatrazescapee.primalwinter.platform.client.XPlatformClient;
import com.alcatrazescapee.primalwinter.util.Config;
import net.minecraft.class_1163;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1926;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5636;

public final class ClientEventHandler {
    private static float prevFogDensity = -1.0f;
    private static long prevFogTick = -1L;

    public static void setupClient() {
        XPlatformClient.INSTANCE.setRenderType(PrimalWinterBlocks.SNOWY_VINE.get(), class_1921.method_23581());
    }

    public static void setupBlockColors(BlockColorCallback colors) {
        colors.accept((state, world, pos, tintIndex) -> tintIndex == 0 ? class_1926.method_8342() : 0, PrimalWinterBlocks.SNOWY_SPRUCE_LEAVES.get());
        colors.accept((state, world, pos, tintIndex) -> tintIndex == 0 ? class_1926.method_8343() : 0, PrimalWinterBlocks.SNOWY_BIRCH_LEAVES.get());
        colors.accept((state, world, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return world != null && pos != null ? class_1163.method_4966((class_1920)world, (class_2338)pos) : class_1926.method_8341();
            }
            return 0xFFFFFF;
        }, PrimalWinterBlocks.SNOWY_OAK_LEAVES.get(), PrimalWinterBlocks.SNOWY_DARK_OAK_LEAVES.get(), PrimalWinterBlocks.SNOWY_JUNGLE_LEAVES.get(), PrimalWinterBlocks.SNOWY_ACACIA_LEAVES.get(), PrimalWinterBlocks.SNOWY_VINE.get());
    }

    public static void setupItemColors(ItemColorCallback colors) {
        colors.accept((stack, tintIndex) -> {
            if (tintIndex == 0) {
                class_2680 state = ((class_1747)stack.method_7909()).method_7711().method_9564();
                return class_310.method_1551().method_1505().method_1697(state, null, null, tintIndex);
            }
            return 0xFFFFFF;
        }, (class_1935)PrimalWinterBlocks.SNOWY_VINE.get(), (class_1935)PrimalWinterBlocks.SNOWY_OAK_LEAVES.get(), (class_1935)PrimalWinterBlocks.SNOWY_SPRUCE_LEAVES.get(), (class_1935)PrimalWinterBlocks.SNOWY_BIRCH_LEAVES.get(), (class_1935)PrimalWinterBlocks.SNOWY_JUNGLE_LEAVES.get(), (class_1935)PrimalWinterBlocks.SNOWY_ACACIA_LEAVES.get(), (class_1935)PrimalWinterBlocks.SNOWY_DARK_OAK_LEAVES.get());
    }

    public static void setupParticleFactories(ParticleProviderCallback particles) {
        particles.accept((class_2396)PrimalWinterAmbience.SNOW.get(), SnowParticle.Provider::new);
    }

    public static void renderFogColors(class_4184 camera, float partialTick, FogColorCallback callback) {
        class_1297 class_12972 = camera.method_19331();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (camera.method_19334() == class_5636.field_27888 && prevFogDensity > 0.0f) {
                float angle = player.field_6002.method_8442(partialTick);
                float height = class_3532.method_15362((float)angle);
                float delta = class_3532.method_15363((float)((height + 0.4f) / 0.8f), (float)0.0f, (float)1.0f);
                int colorDay = Config.INSTANCE.fogColorDay.getAsInt();
                int colorNight = Config.INSTANCE.fogColorNight.getAsInt();
                float red = (float)(colorDay >> 16 & 0xFF) * delta + (float)(colorNight >> 16 & 0xFF) * (1.0f - delta);
                float green = (float)(colorDay >> 8 & 0xFF) * delta + (float)(colorNight >> 8 & 0xFF) * (1.0f - delta);
                float blue = (float)(colorDay & 0xFF) * delta + (float)(colorNight & 0xFF) * (1.0f - delta);
                callback.accept(red / 255.0f, green / 255.0f, blue / 255.0f);
            }
        }
    }

    public static void renderFogDensity(class_4184 camera, FogDensityCallback callback) {
        class_1297 class_12972 = camera.method_19331();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            long thisTick = class_156.method_658();
            boolean firstTick = prevFogTick == -1L;
            float deltaTick = firstTick ? 1.0E10f : (float)(thisTick - prevFogTick) * 1.5E-4f;
            prevFogTick = thisTick;
            float expectedFogDensity = 0.0f;
            class_1937 level = player.field_6002;
            class_1959 biome = (class_1959)level.method_23753(camera.method_19328()).comp_349();
            if (level.method_8419() && biome.method_8694() == class_1959.class_1963.field_9383 && biome.method_33599(camera.method_19328())) {
                int light = level.method_8314(class_1944.field_9284, new class_2338(player.method_33571()));
                expectedFogDensity = class_3532.method_37958((float)light, (float)0.0f, (float)15.0f, (float)0.0f, (float)1.0f);
            }
            if (expectedFogDensity > prevFogDensity) {
                prevFogDensity = Math.min(prevFogDensity + 4.0f * deltaTick, expectedFogDensity);
            } else if (expectedFogDensity < prevFogDensity) {
                prevFogDensity = Math.max(prevFogDensity - deltaTick, expectedFogDensity);
            }
            if (camera.method_19334() != class_5636.field_27888) {
                prevFogDensity = -1.0f;
                prevFogTick = -1L;
            }
            if (prevFogDensity > 0.0f) {
                float scaledDelta = 1.0f - (1.0f - prevFogDensity) * (1.0f - prevFogDensity);
                float fogDensity = Config.INSTANCE.fogDensity.getAsFloat();
                float farPlaneScale = class_3532.method_16439((float)scaledDelta, (float)1.0f, (float)fogDensity);
                float nearPlaneScale = class_3532.method_16439((float)scaledDelta, (float)1.0f, (float)(0.3f * fogDensity));
                callback.accept(nearPlaneScale, farPlaneScale);
            }
        }
    }
}

