/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.world;

import com.alcatrazescapee.primalwinter.blocks.PrimalWinterBlocks;
import com.alcatrazescapee.primalwinter.util.Config;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class ImprovedFreezeTopLayerFeature
extends class_3031<class_3111> {
    public ImprovedFreezeTopLayerFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        int y;
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        class_2338.class_2339 cursor = new class_2338.class_2339();
        int maxY = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                y = level.method_8624(class_2902.class_2903.field_13197, pos.method_10263() + x, pos.method_10260() + z);
                if (maxY >= y) continue;
                maxY = y;
            }
        }
        int[] skyLights = new int[256];
        int[] prevSkyLights = new int[256];
        Arrays.fill(prevSkyLights, 7);
        for (y = maxY; y >= 0; --y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int skyLight = prevSkyLights[x + 16 * z];
                    cursor.method_10103(pos.method_10263() + x, y, pos.method_10260() + z);
                    class_2680 state = level.method_8320((class_2338)cursor);
                    if (state.method_26215()) {
                        skyLights[x + 16 * z] = prevSkyLights[x + 16 * z];
                        this.extendSkyLights(skyLights, x, z);
                    }
                    if (skyLight <= 0) continue;
                    this.placeSnowAndIce(level, (class_2338)cursor, state, context.method_33654(), skyLight);
                }
            }
            boolean hasSkyLight = false;
            for (int i = 0; i < 256; ++i) {
                if (skyLights[i] <= 0) continue;
                hasSkyLight = true;
                break;
            }
            if (!hasSkyLight) break;
            System.arraycopy(skyLights, 0, prevSkyLights, 0, skyLights.length);
            Arrays.fill(skyLights, 0);
        }
        return true;
    }

    private void extendSkyLights(int[] skyLights, int startX, int startZ) {
        ArrayList<class_2382> positions = new ArrayList<class_2382>();
        HashSet<class_2382> visited = new HashSet<class_2382>();
        positions.add(new class_2382(startX, skyLights[startX + 16 * startZ], startZ));
        visited.add(new class_2382(startX, 0, startZ));
        while (!positions.isEmpty()) {
            class_2382 position = (class_2382)positions.remove(0);
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2382 nextVisited;
                int nextX = position.method_10263() + direction.method_10148();
                int nextZ = position.method_10260() + direction.method_10165();
                int nextSkyLight = position.method_10264() - 1;
                if (nextX < 0 || nextX >= 16 || nextZ < 0 || nextZ >= 16 || skyLights[nextX + 16 * nextZ] >= nextSkyLight || visited.contains(nextVisited = new class_2382(nextX, 0, nextZ))) continue;
                skyLights[nextX + 16 * nextZ] = nextSkyLight;
                positions.add(new class_2382(nextX, nextSkyLight, nextZ));
                visited.add(nextVisited);
            }
        }
    }

    private void placeSnowAndIce(class_5281 level, class_2338 pos, class_2680 state, Random random, int skyLight) {
        class_2248 replacementBlock;
        class_1959 biome = (class_1959)level.method_23753(pos).comp_349();
        if (!biome.method_33599(pos) || biome.method_8694() != class_1959.class_1963.field_9383) {
            return;
        }
        class_3610 fluidState = level.method_8316(pos);
        class_2338 posDown = pos.method_10074();
        class_2680 stateDown = level.method_8320(posDown);
        if (state.method_26215() && (replacementBlock = PrimalWinterBlocks.SNOWY_SPECIAL_TERRAIN_BLOCKS.getOrDefault(stateDown.method_26204(), () -> null).get()) != null) {
            class_2680 replacementState = replacementBlock.method_9564();
            level.method_8652(posDown, replacementState, 2);
        }
        if (fluidState.method_15772() == class_3612.field_15910 && (state.method_26204() instanceof class_2404 || state.method_26207().method_15800())) {
            level.method_8652(pos, class_2246.field_10295.method_9564(), 2);
            if (!(state.method_26204() instanceof class_2404)) {
                level.method_39279(pos, class_2246.field_10295, 0);
            }
        } else if (fluidState.method_15772() == class_3612.field_15908 && state.method_26204() instanceof class_2404) {
            level.method_8652(pos, class_2246.field_10540.method_9564(), 2);
        } else if (class_2246.field_10477.method_9564().method_26184((class_4538)level, pos) && state.method_26207().method_15800()) {
            class_2338 posUp = pos.method_10084();
            if (state.method_26204() instanceof class_2320 && level.method_8320(posUp).method_26204() == state.method_26204()) {
                level.method_8650(posUp, false);
            }
            int layers = Config.INSTANCE.enableSnowAccumulationDuringWorldgen.getAsBoolean() ? class_3532.method_15340((int)(skyLight - random.nextInt(3) - this.countExposedFaces(level, pos)), (int)1, (int)7) : 1;
            level.method_8652(pos, (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2741.field_12536, (Comparable)Integer.valueOf(layers)), 3);
            class_2248 replacementBlock2 = PrimalWinterBlocks.SNOWY_TERRAIN_BLOCKS.getOrDefault(stateDown.method_26204(), () -> null).get();
            if (replacementBlock2 != null) {
                class_2680 replacementState = replacementBlock2.method_9564();
                level.method_8652(posDown, replacementState, 2);
            }
        }
    }

    private int countExposedFaces(class_5281 level, class_2338 pos) {
        int count = 0;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 posAt = pos.method_10093(direction);
            if (level.method_8320(posAt).method_26206((class_1922)level, posAt, direction.method_10153())) continue;
            ++count;
        }
        return count;
    }
}

