/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.epsilon;

import com.alcatrazescapee.primalwinter.epsilon.ParseError;
import com.alcatrazescapee.primalwinter.epsilon.Spec;
import com.alcatrazescapee.primalwinter.epsilon.Type;
import com.alcatrazescapee.primalwinter.epsilon.ValueConverter;
import com.alcatrazescapee.primalwinter.epsilon.value.BoolValue;
import com.alcatrazescapee.primalwinter.epsilon.value.FloatValue;
import com.alcatrazescapee.primalwinter.epsilon.value.IntValue;
import com.alcatrazescapee.primalwinter.epsilon.value.TypeValue;
import com.alcatrazescapee.primalwinter.epsilon.value.Value;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface SpecBuilder {
    public SpecBuilder push(String var1);

    public SpecBuilder pop();

    default public SpecBuilder pop(int n) {
        for (int i = 0; i < n; ++i) {
            this.pop();
        }
        return this;
    }

    default public SpecBuilder swap(String name) {
        return this.pop().push(name);
    }

    public SpecBuilder comment(String ... var1);

    default public IntValue define(String name, int defaultValue) {
        return this.define(name, defaultValue, ValueConverter.INT);
    }

    default public IntValue define(String name, int defaultValue, int minValue, int maxValue) {
        return this.comment("Range: [%d, %d]".formatted(minValue, maxValue)).define(name, defaultValue, ValueConverter.forRange(minValue, maxValue));
    }

    default public FloatValue define(String name, float defaultValue) {
        return this.define(name, Float.valueOf(defaultValue), ValueConverter.FLOAT);
    }

    default public FloatValue define(String name, float defaultValue, float minValue, float maxValue) {
        return this.comment("Range: [%s, %s]".formatted(Float.valueOf(minValue), Float.valueOf(maxValue))).define(name, Float.valueOf(defaultValue), ValueConverter.forRange(minValue, maxValue));
    }

    default public BoolValue define(String name, boolean defaultValue) {
        return this.define(name, defaultValue, ValueConverter.BOOL);
    }

    default public TypeValue<String> define(String name, String defaultValue) {
        return this.define(name, defaultValue, ValueConverter.STRING);
    }

    default public TypeValue<String> define(String name, String defaultValue, Predicate<String> predicate, String error) {
        return this.define(name, defaultValue, Type.STRING.map(value -> {
            if (!predicate.test((String)value)) {
                throw new ParseError(error);
            }
        }, TypeValue::new));
    }

    default public TypeValue<List<String>> define(String name, List<String> defaultValue) {
        return this.define(name, defaultValue, ValueConverter.STRING_LIST);
    }

    default public <E extends Enum<E>> TypeValue<E> define(String name, E defaultValue, Class<E> enumClass) {
        return this.define(name, defaultValue, enumClass, EnumSet.allOf(enumClass));
    }

    default public <E extends Enum<E>> TypeValue<E> define(String name, E defaultValue, Class<E> enumClass, E allowedValue, E ... allowedValues) {
        return this.define(name, defaultValue, enumClass, EnumSet.of(allowedValue, allowedValues));
    }

    default public <E extends Enum<E>> TypeValue<E> define(String name, E defaultValue, Class<E> enumClass, EnumSet<E> set) {
        String[] stringArray = new String[1];
        Object[] objectArray = new Object[1];
        objectArray[0] = Arrays.stream((Enum[])enumClass.getEnumConstants()).filter(set::contains).map(Enum::name).collect(Collectors.joining(", "));
        stringArray[0] = "Allowed values: %s".formatted(objectArray);
        return this.comment(stringArray).define(name, defaultValue, ValueConverter.forEnum(enumClass, set));
    }

    public <T, U, V extends Value<U>> V define(String var1, U var2, ValueConverter<T, U, V> var3);

    public Spec build();
}

