/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.platform;

import com.alcatrazescapee.primalwinter.platform.RegistryHolder;
import com.alcatrazescapee.primalwinter.platform.RegistryInterface;
import com.alcatrazescapee.primalwinter.util.Helpers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class FabricRegistryInterface<T>
implements RegistryInterface<T> {
    private final class_2378<T> registry;
    private final List<Holder<? extends T>> holders;

    public FabricRegistryInterface(class_2378<T> registry) {
        this.registry = registry;
        this.holders = new ArrayList<Holder<? extends T>>();
    }

    @Override
    public void lateSetup() {
        this.holders.forEach(holder -> holder.register(this.registry));
        this.holders.clear();
    }

    @Override
    public <V extends T> RegistryHolder<V> register(String name, Supplier<? extends V> factory) {
        Holder<? extends V> holder = new Holder<V>(Helpers.identifier(name), this.registry, factory);
        this.holders.add(holder);
        return holder;
    }

    private static class Holder<T>
    implements RegistryHolder<T> {
        private final class_2960 id;
        private final class_2378<T> registry;
        private final Supplier<? extends T> factory;
        @Nullable
        private T value;

        Holder(class_2960 id, class_2378<T> registry, Supplier<? extends T> factory) {
            this.id = id;
            this.registry = registry;
            this.factory = factory;
        }

        @Override
        public T get() {
            if (this.value == null) {
                throw new NullPointerException("Registry object not present: " + this.id);
            }
            return this.value;
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public class_2378<T> registry() {
            return this.registry;
        }

        private void register(class_2378<? super T> registry) {
            this.value = class_2378.method_10230(registry, (class_2960)this.id, this.factory.get());
        }
    }
}

