/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.util;

import com.alcatrazescapee.primalwinter.blocks.PrimalWinterBlocks;
import com.alcatrazescapee.primalwinter.util.Config;
import com.alcatrazescapee.primalwinter.util.NewWorldSavedData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.slf4j.Logger;

public final class EventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        boolean enable = Config.INSTANCE.enableWeatherCommand.getAsBoolean();
        LOGGER.info("Vanilla /weather enabled = {}", (Object)enable);
        if (!enable) {
            dispatcher.getRoot().getChildren().removeIf(node -> node.getName().equals("weather"));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"weather").executes(source -> {
                ((class_2168)source.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Not even a command can overcome this storm... (This command is disabled by Primal Winter)"), false);
                return 0;
            }));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"primalwinterReloadConfig").requires(c -> c.method_9259(2))).executes(source -> {
            Config.INSTANCE.load();
            return 1;
        }));
    }

    public static void placeExtraSnow(class_3218 level, class_2791 chunk) {
        if (Config.INSTANCE.enableSnowAccumulationDuringWeather.getAsBoolean() && level.field_9229.method_43048(16) == 0) {
            int blockX = chunk.method_12004().method_8326();
            int blockZ = chunk.method_12004().method_8328();
            class_2338 pos = level.method_8598(class_2902.class_2903.field_13197, level.method_8536(blockX, 0, blockZ, 15));
            class_2680 state = level.method_8320(pos);
            class_1959 biome = (class_1959)level.method_23753(pos).comp_349();
            if (level.method_8419() && biome.method_33599(pos) && level.method_8314(class_1944.field_9282, pos) < 10 && state.method_26204() == class_2246.field_10477) {
                class_2338 belowPos;
                class_2680 belowState;
                class_2248 replacementBlock;
                int layers = (Integer)state.method_11654((class_2769)class_2741.field_12536);
                if (layers < 5) {
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12536, (Comparable)Integer.valueOf(1 + layers)));
                }
                if ((replacementBlock = PrimalWinterBlocks.SNOWY_TERRAIN_BLOCKS.getOrDefault((belowState = level.method_8320(belowPos = pos.method_10074())).method_26204(), () -> null).get()) != null) {
                    level.method_8501(belowPos, replacementBlock.method_9564());
                }
            }
        }
    }

    public static void setLevelToThunder(class_1936 maybeLevel) {
        class_3218 level;
        if (maybeLevel instanceof class_3218 && Config.INSTANCE.isWinterDimension((class_5321<class_1937>)(level = (class_3218)maybeLevel).method_27983())) {
            NewWorldSavedData.onlyForNewWorlds(level, () -> {
                LOGGER.info("Modifying weather for world {}", (Object)level.method_27983().method_29177());
                level.method_27910(0, Integer.MAX_VALUE, true, true);
                ((class_1928.class_4310)level.method_8450().method_20746(class_1928.field_19406)).method_20758(false, level.method_8503());
            });
        }
    }
}

