/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.epsilon;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.Nullable;

public final class TomlUtil {
    public static TomlParseResult parse(String text) {
        Scanner scanner = new Scanner(text);
        Parser parser = new Parser(scanner.outputs);
        scanner.scan();
        parser.parse();
        return new TomlParseResult(parser.values, scanner.error || parser.error);
    }

    public static <T> String writeValue(T value) {
        if (value instanceof List) {
            List list = (List)value;
            return "[%s]".formatted(list.stream().map(TomlUtil::writeValue).collect(Collectors.joining(", ")));
        }
        if (value instanceof String) {
            String string = (String)value;
            return "\"%s\"".formatted(StringEscapeUtils.escapeJava((String)string));
        }
        return String.valueOf(value);
    }

    static final class Scanner {
        final List<Token> outputs = new ArrayList<Token>();
        final String text;
        int index;
        boolean error;

        Scanner(String text) {
            this.text = text;
            this.index = 0;
            this.error = false;
        }

        void scan() {
            block10: while (this.hasNext()) {
                char c = this.next();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block10;
                    }
                    case '[': {
                        this.push(TLiteral.LEFT_BRACKET);
                        continue block10;
                    }
                    case ']': {
                        this.push(TLiteral.RIGHT_BRACKET);
                        continue block10;
                    }
                    case '=': {
                        this.push(TLiteral.EQUALS);
                        continue block10;
                    }
                    case '.': {
                        this.push(TLiteral.DOT);
                        continue block10;
                    }
                    case ',': {
                        this.push(TLiteral.COMMA);
                        continue block10;
                    }
                    case '\"': {
                        this.scanString();
                        continue block10;
                    }
                    case '#': {
                        this.scanComment();
                        continue block10;
                    }
                }
                if (this.isNumberPrefix(c)) {
                    this.scanNumber();
                    continue;
                }
                if (this.isNamePrefix(c)) {
                    this.scanName();
                    continue;
                }
                this.error = true;
            }
        }

        void scanString() {
            int start = this.index;
            while (this.hasNext() && this.peek() != '\"') {
                if (this.next() != '\\') continue;
                this.next();
            }
            this.push(new TString(StringEscapeUtils.unescapeJava((String)this.text.substring(start, this.index))));
            this.next();
        }

        void scanComment() {
            while (this.hasNext() && this.peek() != '\n') {
                this.next();
            }
        }

        void scanNumber() {
            int start = this.index - 1;
            while (this.isNumber(this.peek())) {
                this.next();
            }
            this.push(this.parseNumber(this.text.substring(start, this.index)));
        }

        Token parseNumber(String value) {
            try {
                return new TInt(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return new TFloat(Float.valueOf(Float.parseFloat(value)));
                }
                catch (NumberFormatException numberFormatException2) {
                    return TLiteral.INVALID;
                }
            }
        }

        void scanName() {
            String value;
            int start = this.index - 1;
            while (this.isName(this.peek())) {
                this.next();
            }
            this.push(switch (value = this.text.substring(start, this.index)) {
                case "true" -> TLiteral.TRUE;
                case "false" -> TLiteral.FALSE;
                default -> new TName(value);
            });
        }

        boolean isNamePrefix(char c) {
            return Character.isLetter(c);
        }

        boolean isName(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '-';
        }

        boolean isNumberPrefix(char c) {
            return c == '-' || c == '+' || this.isNumber(c);
        }

        boolean isNumber(char c) {
            return c == '.' || Character.isDigit(c);
        }

        boolean hasNext() {
            return this.index < this.text.length();
        }

        char peek() {
            return this.hasNext() ? this.text.charAt(this.index) : (char)'\u0000';
        }

        char next() {
            char c = this.peek();
            ++this.index;
            return c;
        }

        void push(Token token) {
            this.outputs.add(token);
        }
    }

    static final class Parser {
        final List<Token> inputs;
        final Map<String, Object> values;
        @Nullable
        String category;
        int index;
        boolean error;

        Parser(List<Token> inputs) {
            this.inputs = inputs;
            this.values = new HashMap<String, Object>();
            this.category = null;
            this.index = 0;
            this.error = false;
        }

        void parse() {
            while (this.hasNext()) {
                Token t = this.next();
                if (t == TLiteral.LEFT_BRACKET) {
                    this.parseCategory();
                    continue;
                }
                if (t instanceof TName) {
                    TName name = (TName)t;
                    this.parseKeyValuePair(name.value);
                    continue;
                }
                this.error = true;
                this.next();
            }
        }

        void parseCategory() {
            Token token;
            if (!(this.peek() instanceof TName)) {
                this.error = true;
                return;
            }
            ArrayList<String> category = new ArrayList<String>();
            while ((token = this.peek()) instanceof TName) {
                TName name = (TName)token;
                category.add(name.value);
                this.next();
                if (this.peek() == TLiteral.RIGHT_BRACKET) {
                    this.next();
                    this.category = String.join((CharSequence)".", category);
                    break;
                }
                if (this.peek() == TLiteral.DOT) {
                    this.next();
                    continue;
                }
                this.error = true;
                break;
            }
        }

        void parseKeyValuePair(String key) {
            if (this.next() != TLiteral.EQUALS) {
                this.error = true;
                return;
            }
            Object value = this.parseValue();
            if (value == null) {
                this.error = true;
                return;
            }
            String longKey = this.category == null ? key : this.category + "." + key;
            this.values.put(longKey, value);
        }

        @Nullable
        Object parseValue() {
            if (this.peek() == TLiteral.LEFT_BRACKET) {
                this.next();
                return this.parseListValue();
            }
            if (this.isValue(this.peek())) {
                return this.next().value();
            }
            return null;
        }

        @Nullable
        List<Object> parseListValue() {
            ArrayList<Object> list = new ArrayList<Object>();
            while (this.hasNext()) {
                Object value = this.parseValue();
                if (value == null) {
                    return null;
                }
                list.add(value);
                if (this.peek() == TLiteral.RIGHT_BRACKET) {
                    this.next();
                    return list;
                }
                if (this.peek() != TLiteral.COMMA) break;
                this.next();
            }
            return null;
        }

        boolean isValue(Token t) {
            return t instanceof TString || t instanceof TInt || t instanceof TFloat || t == TLiteral.TRUE || t == TLiteral.FALSE;
        }

        boolean hasNext() {
            return this.index < this.inputs.size();
        }

        Token peek() {
            return this.hasNext() ? this.inputs.get(this.index) : TLiteral.INVALID;
        }

        Token next() {
            Token t = this.peek();
            ++this.index;
            return t;
        }
    }

    public record TomlParseResult(Map<String, Object> map, boolean errors) {
    }

    static final class TList
    extends Record
    implements Token {
        private final List<Token> value;

        TList(List<Token> value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TList.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TList.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TList.class, "value", "value"}, this, o);
        }

        @Override
        public List<Token> value() {
            return this.value;
        }
    }

    static final class TFloat
    extends Record
    implements Token {
        private final Float value;

        TFloat(Float value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TFloat.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TFloat.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TFloat.class, "value", "value"}, this, o);
        }

        @Override
        public Float value() {
            return this.value;
        }
    }

    static final class TInt
    extends Record
    implements Token {
        private final Integer value;

        TInt(Integer value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TInt.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TInt.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TInt.class, "value", "value"}, this, o);
        }

        @Override
        public Integer value() {
            return this.value;
        }
    }

    static final class TName
    extends Record
    implements Token {
        private final String value;

        TName(String value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TName.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TName.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TName.class, "value", "value"}, this, o);
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    static final class TString
    extends Record
    implements Token {
        private final String value;

        TString(String value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TString.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TString.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TString.class, "value", "value"}, this, o);
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    static enum TLiteral implements Token
    {
        DOT,
        COMMA,
        EQUALS,
        LEFT_BRACKET,
        RIGHT_BRACKET,
        TRUE,
        FALSE,
        INVALID;


        @Override
        public Object value() {
            return this == TRUE ? Boolean.valueOf(true) : (this == FALSE ? Boolean.valueOf(false) : this);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Token {
        public Object value();
    }
}

