/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter;

import com.alcatrazescapee.primalwinter.ForgePrimalWinterClient;
import com.alcatrazescapee.primalwinter.PrimalWinter;
import com.alcatrazescapee.primalwinter.platform.XPlatform;
import com.alcatrazescapee.primalwinter.util.Config;
import com.alcatrazescapee.primalwinter.util.EventHandler;
import com.alcatrazescapee.primalwinter.world.PrimalWinterWorldGen;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="primalwinter")
public final class ForgePrimalWinter {
    public ForgePrimalWinter() {
        PrimalWinter.earlySetup();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(event -> PrimalWinter.lateSetup());
        forgeBus.addListener(event -> EventHandler.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher()));
        forgeBus.addListener(event -> EventHandler.setLevelToThunder(event.getWorld()));
        forgeBus.addListener(this::modifyBiomes);
        if (XPlatform.INSTANCE.isDedicatedClient()) {
            ForgePrimalWinterClient.setupClient();
        }
    }

    private void modifyBiomes(BiomeLoadingEvent event) {
        if (!Config.INSTANCE.isWinterBiome(event.getName())) {
            return;
        }
        event.setClimate(new Biome.ClimateSettings(Biome.Precipitation.SNOW, -0.5f, Biome.TemperatureModifier.NONE, event.getClimate().f_47683_));
        BiomeSpecialEffects effects = event.getEffects();
        BiomeSpecialEffects.Builder newEffects = new BiomeSpecialEffects.Builder().m_48034_(3750089).m_48037_(329011).m_48019_(effects.m_47967_()).m_48040_(effects.m_47978_()).m_48031_(effects.m_47987_());
        effects.m_47981_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)newEffects).m_48043_(arg_0));
        effects.m_47984_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)newEffects).m_48045_(arg_0));
        effects.m_47990_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)newEffects).m_48029_(arg_0));
        effects.m_47993_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)newEffects).m_48023_(arg_0));
        effects.m_47996_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)newEffects).m_48027_(arg_0));
        effects.m_47999_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)newEffects).m_48025_(arg_0));
        effects.m_48002_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)newEffects).m_48021_(arg_0));
        event.setEffects(newEffects.m_48018_());
        BiomeGenerationSettingsBuilder settings = event.getGeneration();
        settings.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, PrimalWinterWorldGen.Placed.ICE_SPIKES.holder());
        settings.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, PrimalWinterWorldGen.Placed.ICE_PATCH.holder());
        settings.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, PrimalWinterWorldGen.Placed.SNOW_PATCH.holder());
        settings.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, PrimalWinterWorldGen.Placed.POWDER_SNOW_PATCH.holder());
        settings.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PrimalWinterWorldGen.Placed.FREEZE_TOP_LAYER.holder());
        MobSpawnSettingsBuilder spawns = event.getSpawns();
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20514_, 60, 1, 3));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20481_, 60, 1, 3));
    }
}

