/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.mixin.client;

import com.alcatrazescapee.primalwinter.client.PrimalWinterAmbience;
import com.alcatrazescapee.primalwinter.util.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private static ResourceLocation f_109460_;
    @Shadow
    private ClientLevel f_109465_;
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Shadow
    private int f_109477_;
    @Shadow
    private int f_109450_;
    private int windSoundTime;

    @Redirect(method={"renderSnowAndRain"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;warmEnoughToRain(Lnet/minecraft/core/BlockPos;)Z"))
    private boolean alwaysUseRainRendering(Biome biome, BlockPos pos) {
        if (Config.INSTANCE.weatherRenderChanges.getAsBoolean()) {
            return true;
        }
        return biome.m_198906_(pos);
    }

    @Redirect(method={"renderSnowAndRain"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;getLightColor(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;)I"))
    private int getAdjustedLightColorForSnow(BlockAndTintGetter level, BlockPos pos) {
        int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos);
        if (Config.INSTANCE.weatherRenderChanges.getAsBoolean()) {
            int lightU = packedLight & 0xFFFF;
            int lightV = packedLight >> 16 & 0xFFFF;
            int brightLightU = (lightU * 3 + 240) / 4;
            int brightLightV = (lightV * 3 + 240) / 4;
            return brightLightU | brightLightV << 16;
        }
        return packedLight;
    }

    @Inject(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/BufferBuilder;begin(Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;Lcom/mojang/blaze3d/vertex/VertexFormat;)V")})
    private void overrideWithSnowTextures(LightTexture lightTexture, float partialTick, double x, double y, double z, CallbackInfo ci) {
        if (Config.INSTANCE.weatherRenderChanges.getAsBoolean()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_109460_);
        }
    }

    @ModifyConstant(method={"renderSnowAndRain"}, constant={@Constant(intValue=5), @Constant(intValue=10)})
    private int modifySnowAmount(int constant) {
        return Config.INSTANCE.snowDensity.getAsInt();
    }

    @Inject(method={"tickRain"}, at={@At(value="HEAD")})
    private void addExtraSnowParticlesAndSounds(Camera camera, CallbackInfo ci) {
        float rain;
        if (!Config.INSTANCE.snowSounds.getAsBoolean()) {
            this.f_109450_ = -1;
        }
        if ((rain = this.f_109465_.m_46722_(1.0f) / (Minecraft.m_91405_() ? 1.0f : 2.0f)) > 0.0f) {
            Random random = new Random((long)this.f_109477_ * 312987231L);
            BlockPos cameraPos = new BlockPos(camera.m_90583_());
            BlockPos pos = null;
            int particleCount = (int)(100.0f * rain * rain) / (this.f_109461_.f_91066_.f_92073_ == ParticleStatus.DECREASED ? 2 : 1);
            for (int i = 0; i < particleCount; ++i) {
                BlockPos randomPos = this.f_109465_.m_5452_(Heightmap.Types.MOTION_BLOCKING, cameraPos.m_142082_(random.nextInt(21) - 10, 0, random.nextInt(21) - 10));
                Biome biome = (Biome)this.f_109465_.m_204166_(randomPos).m_203334_();
                if (randomPos.m_123342_() <= this.f_109465_.m_141937_() || randomPos.m_123342_() > cameraPos.m_123342_() + 10 || randomPos.m_123342_() < cameraPos.m_123342_() - 10 || biome.m_47530_() != Biome.Precipitation.SNOW || !biome.m_198904_(randomPos)) continue;
                pos = randomPos.m_7495_();
                if (this.f_109461_.f_91066_.f_92073_ == ParticleStatus.MINIMAL) break;
                double dx = random.nextDouble();
                double dz = random.nextDouble();
                BlockState state = this.f_109465_.m_8055_(pos);
                FluidState fluid = this.f_109465_.m_6425_(pos);
                double blockY = state.m_60812_((BlockGetter)this.f_109465_, pos).m_83290_(Direction.Axis.Y, dx, dz);
                double fluidY = fluid.m_76155_((BlockGetter)this.f_109465_, pos);
                SimpleParticleType particle = !fluid.m_205070_(FluidTags.f_13132_) && !state.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)state) ? (ParticleOptions)PrimalWinterAmbience.SNOW.get() : ParticleTypes.f_123762_;
                this.f_109465_.m_7106_((ParticleOptions)particle, (double)pos.m_123341_() + dx, (double)pos.m_123342_() + Math.max(blockY, fluidY), (double)pos.m_123343_() + dz, 0.0, 0.0, 0.0);
            }
            if (pos != null && random.nextInt(3) < this.f_109450_++) {
                this.f_109450_ = 0;
                if (pos.m_123342_() > cameraPos.m_123342_() + 1 && this.f_109465_.m_5452_(Heightmap.Types.MOTION_BLOCKING, cameraPos).m_123342_() > Mth.m_14143_((float)cameraPos.m_123342_())) {
                    this.f_109465_.m_104677_(pos, SoundEvents.f_12542_, SoundSource.WEATHER, 0.05f, 0.2f, false);
                } else {
                    this.f_109465_.m_104677_(pos, SoundEvents.f_12541_, SoundSource.WEATHER, 0.1f, 0.5f, false);
                }
            }
            if (this.windSoundTime-- < 0 && Config.INSTANCE.windSounds.getAsBoolean()) {
                BlockPos playerPos = camera.m_90588_();
                Entity entity = camera.m_90592_();
                int light = camera.m_90592_().f_19853_.m_45517_(LightLayer.SKY, playerPos);
                if (light > 3 && entity.f_19853_.m_46471_() && ((Biome)entity.f_19853_.m_204166_(playerPos).m_203334_()).m_198904_(playerPos)) {
                    float volumeModifier = 0.2f + (float)(light - 3) * 0.01f;
                    float pitchModifier = 0.7f;
                    if (camera.m_167685_() != FogType.NONE) {
                        pitchModifier = 0.3f;
                    }
                    this.windSoundTime = 60 + random.nextInt(30);
                    this.f_109465_.m_104677_(playerPos, PrimalWinterAmbience.WIND.get(), SoundSource.WEATHER, volumeModifier, pitchModifier, false);
                } else {
                    this.windSoundTime += 5;
                }
            }
        }
    }
}

