/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.world;

import com.alcatrazescapee.primalwinter.blocks.PrimalWinterBlocks;
import com.alcatrazescapee.primalwinter.util.Config;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class ImprovedFreezeTopLayerFeature
extends Feature<NoneFeatureConfiguration> {
    public ImprovedFreezeTopLayerFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int y;
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int maxY = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_() + x, pos.m_123343_() + z);
                if (maxY >= y) continue;
                maxY = y;
            }
        }
        int[] skyLights = new int[256];
        int[] prevSkyLights = new int[256];
        Arrays.fill(prevSkyLights, 7);
        for (y = maxY; y >= 0; --y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int skyLight = prevSkyLights[x + 16 * z];
                    cursor.m_122178_(pos.m_123341_() + x, y, pos.m_123343_() + z);
                    BlockState state = level.m_8055_((BlockPos)cursor);
                    if (state.m_60795_()) {
                        skyLights[x + 16 * z] = prevSkyLights[x + 16 * z];
                        this.extendSkyLights(skyLights, x, z);
                    }
                    if (skyLight <= 0) continue;
                    this.placeSnowAndIce(level, (BlockPos)cursor, state, context.m_159776_(), skyLight);
                }
            }
            boolean hasSkyLight = false;
            for (int i = 0; i < 256; ++i) {
                if (skyLights[i] <= 0) continue;
                hasSkyLight = true;
                break;
            }
            if (!hasSkyLight) break;
            System.arraycopy(skyLights, 0, prevSkyLights, 0, skyLights.length);
            Arrays.fill(skyLights, 0);
        }
        return true;
    }

    private void extendSkyLights(int[] skyLights, int startX, int startZ) {
        ArrayList<Vec3i> positions = new ArrayList<Vec3i>();
        HashSet<Vec3i> visited = new HashSet<Vec3i>();
        positions.add(new Vec3i(startX, skyLights[startX + 16 * startZ], startZ));
        visited.add(new Vec3i(startX, 0, startZ));
        while (!positions.isEmpty()) {
            Vec3i position = (Vec3i)positions.remove(0);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vec3i nextVisited;
                int nextX = position.m_123341_() + direction.m_122429_();
                int nextZ = position.m_123343_() + direction.m_122431_();
                int nextSkyLight = position.m_123342_() - 1;
                if (nextX < 0 || nextX >= 16 || nextZ < 0 || nextZ >= 16 || skyLights[nextX + 16 * nextZ] >= nextSkyLight || visited.contains(nextVisited = new Vec3i(nextX, 0, nextZ))) continue;
                skyLights[nextX + 16 * nextZ] = nextSkyLight;
                positions.add(new Vec3i(nextX, nextSkyLight, nextZ));
                visited.add(nextVisited);
            }
        }
    }

    private void placeSnowAndIce(WorldGenLevel level, BlockPos pos, BlockState state, Random random, int skyLight) {
        Block replacementBlock;
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        if (!biome.m_198904_(pos) || biome.m_47530_() != Biome.Precipitation.SNOW) {
            return;
        }
        FluidState fluidState = level.m_6425_(pos);
        BlockPos posDown = pos.m_7495_();
        BlockState stateDown = level.m_8055_(posDown);
        if (state.m_60795_() && (replacementBlock = PrimalWinterBlocks.SNOWY_SPECIAL_TERRAIN_BLOCKS.getOrDefault(stateDown.m_60734_(), () -> null).get()) != null) {
            BlockState replacementState = replacementBlock.m_49966_();
            level.m_7731_(posDown, replacementState, 2);
        }
        if (fluidState.m_76152_() == Fluids.f_76193_ && (state.m_60734_() instanceof LiquidBlock || state.m_60767_().m_76336_())) {
            level.m_7731_(pos, Blocks.f_50126_.m_49966_(), 2);
            if (!(state.m_60734_() instanceof LiquidBlock)) {
                level.m_186460_(pos, Blocks.f_50126_, 0);
            }
        } else if (fluidState.m_76152_() == Fluids.f_76195_ && state.m_60734_() instanceof LiquidBlock) {
            level.m_7731_(pos, Blocks.f_50080_.m_49966_(), 2);
        } else if (Blocks.f_50125_.m_49966_().m_60710_((LevelReader)level, pos) && state.m_60767_().m_76336_()) {
            BlockPos posUp = pos.m_7494_();
            if (state.m_60734_() instanceof DoublePlantBlock && level.m_8055_(posUp).m_60734_() == state.m_60734_()) {
                level.m_7471_(posUp, false);
            }
            int layers = Config.INSTANCE.enableSnowAccumulationDuringWorldgen.getAsBoolean() ? Mth.m_14045_((int)(skyLight - random.nextInt(3) - this.countExposedFaces(level, pos)), (int)1, (int)7) : 1;
            level.m_7731_(pos, (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(layers)), 3);
            Block replacementBlock2 = PrimalWinterBlocks.SNOWY_TERRAIN_BLOCKS.getOrDefault(stateDown.m_60734_(), () -> null).get();
            if (replacementBlock2 != null) {
                BlockState replacementState = replacementBlock2.m_49966_();
                level.m_7731_(posDown, replacementState, 2);
            }
        }
    }

    private int countExposedFaces(WorldGenLevel level, BlockPos pos) {
        int count = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos posAt = pos.m_142300_(direction);
            if (level.m_8055_(posAt).m_60783_((BlockGetter)level, posAt, direction.m_122424_())) continue;
            ++count;
        }
        return count;
    }
}

