/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter;

import com.alcatrazescapee.primalwinter.ForgePrimalWinterClient;
import com.alcatrazescapee.primalwinter.PrimalWinter;
import com.alcatrazescapee.primalwinter.platform.XPlatform;
import com.alcatrazescapee.primalwinter.util.Config;
import com.alcatrazescapee.primalwinter.util.EventHandler;
import com.alcatrazescapee.primalwinter.world.PrimalWinterWorldGen;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ClimateSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="primalwinter")
public final class ForgePrimalWinter {
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"primalwinter");
    public static final RegistryObject<Codec<? extends Instance>> CODEC = BIOME_MODIFIERS.register("instance", () -> Codec.unit((Object)((Object)Instance.INSTANCE)));

    public ForgePrimalWinter() {
        PrimalWinter.earlySetup();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(event -> PrimalWinter.lateSetup());
        BIOME_MODIFIERS.register(modBus);
        forgeBus.addListener(event -> EventHandler.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher()));
        forgeBus.addListener(event -> EventHandler.setLevelToThunder(event.getLevel()));
        if (XPlatform.INSTANCE.isDedicatedClient()) {
            ForgePrimalWinterClient.setupClient();
        }
    }

    static enum Instance implements BiomeModifier
    {
        INSTANCE;


        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (biome.m_203543_().map(k -> !Config.INSTANCE.isWinterBiome(k.m_135782_())).orElse(true).booleanValue() || phase != BiomeModifier.Phase.MODIFY) {
                return;
            }
            ClimateSettingsBuilder climate = builder.getClimateSettings();
            climate.setPrecipitation(Biome.Precipitation.SNOW);
            climate.setTemperature(-0.5f);
            climate.setTemperatureModifier(Biome.TemperatureModifier.NONE);
            builder.getSpecialEffects().m_48034_(3750089).m_48037_(329011);
            BiomeGenerationSettingsBuilder settings = builder.getGenerationSettings();
            settings.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, PrimalWinterWorldGen.Placed.ICE_SPIKES.holder());
            settings.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, PrimalWinterWorldGen.Placed.ICE_PATCH.holder());
            settings.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, PrimalWinterWorldGen.Placed.SNOW_PATCH.holder());
            settings.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, PrimalWinterWorldGen.Placed.POWDER_SNOW_PATCH.holder());
            settings.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PrimalWinterWorldGen.Placed.FREEZE_TOP_LAYER.holder());
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20514_, 60, 1, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20481_, 60, 1, 3));
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)CODEC.get();
        }
    }
}

