/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.client;

import com.alcatrazescapee.primalwinter.blocks.PrimalWinterBlocks;
import com.alcatrazescapee.primalwinter.client.PrimalWinterAmbience;
import com.alcatrazescapee.primalwinter.client.SnowParticle;
import com.alcatrazescapee.primalwinter.platform.client.BlockColorCallback;
import com.alcatrazescapee.primalwinter.platform.client.FogColorCallback;
import com.alcatrazescapee.primalwinter.platform.client.FogDensityCallback;
import com.alcatrazescapee.primalwinter.platform.client.ItemColorCallback;
import com.alcatrazescapee.primalwinter.platform.client.ParticleProviderCallback;
import com.alcatrazescapee.primalwinter.platform.client.XPlatformClient;
import com.alcatrazescapee.primalwinter.util.Config;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;

public final class ClientEventHandler {
    private static float prevFogDensity = -1.0f;
    private static long prevFogTick = -1L;

    public static void setupClient() {
        XPlatformClient.INSTANCE.setRenderType(PrimalWinterBlocks.SNOWY_VINE.get(), RenderType.m_110463_());
    }

    public static void setupBlockColors(BlockColorCallback colors) {
        colors.accept((state, world, pos, tintIndex) -> tintIndex == 0 ? FoliageColor.m_46106_() : 0, PrimalWinterBlocks.SNOWY_SPRUCE_LEAVES.get());
        colors.accept((state, world, pos, tintIndex) -> tintIndex == 0 ? FoliageColor.m_46112_() : 0, PrimalWinterBlocks.SNOWY_BIRCH_LEAVES.get());
        colors.accept((state, world, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return world != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.m_46113_();
            }
            return 0xFFFFFF;
        }, PrimalWinterBlocks.SNOWY_OAK_LEAVES.get(), PrimalWinterBlocks.SNOWY_DARK_OAK_LEAVES.get(), PrimalWinterBlocks.SNOWY_JUNGLE_LEAVES.get(), PrimalWinterBlocks.SNOWY_ACACIA_LEAVES.get(), PrimalWinterBlocks.SNOWY_VINE.get());
    }

    public static void setupItemColors(ItemColorCallback colors) {
        colors.accept((stack, tintIndex) -> {
            if (tintIndex == 0) {
                BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
                return Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, tintIndex);
            }
            return 0xFFFFFF;
        }, (ItemLike)PrimalWinterBlocks.SNOWY_VINE.get(), (ItemLike)PrimalWinterBlocks.SNOWY_OAK_LEAVES.get(), (ItemLike)PrimalWinterBlocks.SNOWY_SPRUCE_LEAVES.get(), (ItemLike)PrimalWinterBlocks.SNOWY_BIRCH_LEAVES.get(), (ItemLike)PrimalWinterBlocks.SNOWY_JUNGLE_LEAVES.get(), (ItemLike)PrimalWinterBlocks.SNOWY_ACACIA_LEAVES.get(), (ItemLike)PrimalWinterBlocks.SNOWY_DARK_OAK_LEAVES.get());
    }

    public static void setupParticleFactories(ParticleProviderCallback particles) {
        particles.accept((ParticleType)PrimalWinterAmbience.SNOW.get(), SnowParticle.Provider::new);
    }

    public static void renderFogColors(Camera camera, float partialTick, FogColorCallback callback) {
        Entity entity = camera.m_90592_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (camera.m_167685_() == FogType.NONE && prevFogDensity > 0.0f) {
                float angle = player.f_19853_.m_46490_(partialTick);
                float height = Mth.m_14089_((float)angle);
                float delta = Mth.m_14036_((float)((height + 0.4f) / 0.8f), (float)0.0f, (float)1.0f);
                int colorDay = Config.INSTANCE.fogColorDay.getAsInt();
                int colorNight = Config.INSTANCE.fogColorNight.getAsInt();
                float red = (float)(colorDay >> 16 & 0xFF) * delta + (float)(colorNight >> 16 & 0xFF) * (1.0f - delta);
                float green = (float)(colorDay >> 8 & 0xFF) * delta + (float)(colorNight >> 8 & 0xFF) * (1.0f - delta);
                float blue = (float)(colorDay & 0xFF) * delta + (float)(colorNight & 0xFF) * (1.0f - delta);
                callback.accept(red / 255.0f, green / 255.0f, blue / 255.0f);
            }
        }
    }

    public static void renderFogDensity(Camera camera, FogDensityCallback callback) {
        Entity entity = camera.m_90592_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            long thisTick = Util.m_137550_();
            boolean firstTick = prevFogTick == -1L;
            float deltaTick = firstTick ? 1.0E10f : (float)(thisTick - prevFogTick) * 1.5E-4f;
            prevFogTick = thisTick;
            float expectedFogDensity = 0.0f;
            Level level = player.f_19853_;
            Biome biome = (Biome)level.m_204166_(camera.m_90588_()).m_203334_();
            if (level.m_46471_() && biome.m_47530_() == Biome.Precipitation.SNOW && biome.m_198904_(camera.m_90588_())) {
                int light = level.m_45517_(LightLayer.SKY, new BlockPos(player.m_146892_()));
                expectedFogDensity = Mth.m_184631_((float)light, (float)0.0f, (float)15.0f, (float)0.0f, (float)1.0f);
            }
            if (expectedFogDensity > prevFogDensity) {
                prevFogDensity = Math.min(prevFogDensity + 4.0f * deltaTick, expectedFogDensity);
            } else if (expectedFogDensity < prevFogDensity) {
                prevFogDensity = Math.max(prevFogDensity - deltaTick, expectedFogDensity);
            }
            if (camera.m_167685_() != FogType.NONE) {
                prevFogDensity = -1.0f;
                prevFogTick = -1L;
            }
            if (prevFogDensity > 0.0f) {
                float scaledDelta = 1.0f - (1.0f - prevFogDensity) * (1.0f - prevFogDensity);
                float fogDensity = Config.INSTANCE.fogDensity.getAsFloat();
                float farPlaneScale = Mth.m_14179_((float)scaledDelta, (float)1.0f, (float)fogDensity);
                float nearPlaneScale = Mth.m_14179_((float)scaledDelta, (float)1.0f, (float)(0.3f * fogDensity));
                callback.accept(nearPlaneScale, farPlaneScale);
            }
        }
    }
}

