/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.util;

import com.alcatrazescapee.primalwinter.blocks.PrimalWinterBlocks;
import com.alcatrazescapee.primalwinter.util.Config;
import com.alcatrazescapee.primalwinter.util.NewWorldSavedData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;

public final class EventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        boolean enable = Config.INSTANCE.enableWeatherCommand.getAsBoolean();
        LOGGER.info("Vanilla /weather enabled = {}", (Object)enable);
        if (!enable) {
            dispatcher.getRoot().getChildren().removeIf(node -> node.getName().equals("weather"));
            dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"weather").executes(source -> {
                ((CommandSourceStack)source.getSource()).m_81354_((Component)Component.m_237113_((String)"Not even a command can overcome this storm... (This command is disabled by Primal Winter)"), false);
                return 0;
            }));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"primalwinterReloadConfig").requires(c -> c.m_6761_(2))).executes(source -> {
            Config.INSTANCE.load();
            return 1;
        }));
    }

    public static void placeExtraSnow(ServerLevel level, ChunkAccess chunk) {
        if (Config.INSTANCE.enableSnowAccumulationDuringWeather.getAsBoolean() && level.f_46441_.m_188503_(16) == 0) {
            int blockX = chunk.m_7697_().m_45604_();
            int blockZ = chunk.m_7697_().m_45605_();
            BlockPos pos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, level.m_46496_(blockX, 0, blockZ, 15));
            BlockState state = level.m_8055_(pos);
            Biome biome = (Biome)level.m_204166_(pos).m_203334_();
            if (level.m_46471_() && biome.m_198904_(pos) && level.m_45517_(LightLayer.BLOCK, pos) < 10 && state.m_60734_() == Blocks.f_50125_) {
                BlockPos belowPos;
                BlockState belowState;
                Block replacementBlock;
                int layers = (Integer)state.m_61143_((Property)BlockStateProperties.f_61417_);
                if (layers < 5) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(1 + layers)));
                }
                if ((replacementBlock = PrimalWinterBlocks.SNOWY_TERRAIN_BLOCKS.getOrDefault((belowState = level.m_8055_(belowPos = pos.m_7495_())).m_60734_(), () -> null).get()) != null) {
                    level.m_46597_(belowPos, replacementBlock.m_49966_());
                }
            }
        }
    }

    public static void setLevelToThunder(LevelAccessor maybeLevel) {
        ServerLevel level;
        if (maybeLevel instanceof ServerLevel && Config.INSTANCE.isWinterDimension((ResourceKey<Level>)(level = (ServerLevel)maybeLevel).m_46472_())) {
            NewWorldSavedData.onlyForNewWorlds(level, () -> {
                LOGGER.info("Modifying weather for world {}", (Object)level.m_46472_().m_135782_());
                level.m_8606_(0, Integer.MAX_VALUE, true, true);
                ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46150_)).m_46246_(false, level.m_7654_());
            });
        }
    }
}

