/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.world;

import com.alcatrazescapee.primalwinter.blocks.PrimalWinterBlocks;
import com.alcatrazescapee.primalwinter.platform.RegistryHolder;
import com.alcatrazescapee.primalwinter.platform.RegistryInterface;
import com.alcatrazescapee.primalwinter.platform.XPlatform;
import com.alcatrazescapee.primalwinter.world.ImprovedFreezeTopLayerFeature;
import com.alcatrazescapee.primalwinter.world.ImprovedIceSpikeFeature;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.DiskFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public final class PrimalWinterWorldGen {

    public static final class Placed {
        public static final RegistryInterface<PlacedFeature> PLACED_FEATURES = XPlatform.INSTANCE.registryInterface(BuiltinRegistries.f_194653_);
        public static final RegistryHolder<PlacedFeature> FREEZE_TOP_LAYER = Placed.register("freeze_top_layer", Configured.FREEZE_TOP_LAYER, new PlacementModifier[0]);
        public static final RegistryHolder<PlacedFeature> ICE_SPIKES = Placed.register("ice_spikes", Configured.ICE_SPIKES, new PlacementModifier[]{RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        public static final RegistryHolder<PlacedFeature> ICE_PATCH = Placed.register("ice_patch", Configured.ICE_PATCH, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        public static final RegistryHolder<PlacedFeature> SNOW_PATCH = Placed.register("snow_patch", Configured.SNOW_PATCH, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        public static final RegistryHolder<PlacedFeature> POWDER_SNOW_PATCH = Placed.register("powder_snow_patch", Configured.POWDER_SNOW_PATCH, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});

        private static RegistryHolder<PlacedFeature> register(String name, RegistryHolder<ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature(Holder.m_205706_(feature.holder()), Arrays.asList(modifiers)));
        }
    }

    public static final class Configured {
        public static final RegistryInterface<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = XPlatform.INSTANCE.registryInterface(BuiltinRegistries.f_123861_);
        public static final RegistryHolder<ConfiguredFeature<?, ?>> FREEZE_TOP_LAYER = Configured.register("freeze_top_layer", Features.FREEZE_TOP_LAYER, () -> NoneFeatureConfiguration.f_67816_);
        public static final RegistryHolder<ConfiguredFeature<?, ?>> ICE_SPIKES = Configured.register("ice_spikes", Features.ICE_SPIKES, () -> NoneFeatureConfiguration.f_67816_);
        public static final RegistryHolder<ConfiguredFeature<?, ?>> ICE_PATCH = Configured.register("ice_patch", Features.DISK, () -> new DiskConfiguration(RuleBasedBlockStateProvider.m_225936_((Block)Blocks.f_50354_), Configured.snowyReplaceableBlocks(), (IntProvider)UniformInt.m_146622_((int)2, (int)3), 1));
        public static final RegistryHolder<ConfiguredFeature<?, ?>> SNOW_PATCH = Configured.register("snow_patch", Features.DISK, () -> new DiskConfiguration(RuleBasedBlockStateProvider.m_225936_((Block)Blocks.f_50127_), Configured.snowyReplaceableBlocks(), (IntProvider)UniformInt.m_146622_((int)2, (int)3), 1));
        public static final RegistryHolder<ConfiguredFeature<?, ?>> POWDER_SNOW_PATCH = Configured.register("powder_snow_patch", Features.DISK, () -> new DiskConfiguration(RuleBasedBlockStateProvider.m_225936_((Block)Blocks.f_152499_), Configured.snowyReplaceableBlocks(), (IntProvider)UniformInt.m_146622_((int)2, (int)3), 1));

        private static <C extends FeatureConfiguration, F extends Feature<C>> RegistryHolder<ConfiguredFeature<?, ?>> register(String name, Supplier<F> feature, Supplier<C> config) {
            return CONFIGURED_FEATURES.register(name, () -> new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)config.get()));
        }

        private static BlockPredicate snowyReplaceableBlocks() {
            return BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50493_, Blocks.f_50440_, Blocks.f_50599_, Blocks.f_50546_, Blocks.f_50195_, Blocks.f_50127_, Blocks.f_50126_, Blocks.f_49992_, Blocks.f_49993_, PrimalWinterBlocks.SNOWY_DIRT.get(), PrimalWinterBlocks.SNOWY_COARSE_DIRT.get(), PrimalWinterBlocks.SNOWY_SAND.get(), PrimalWinterBlocks.SNOWY_RED_SAND.get()});
        }
    }

    public static final class Features {
        public static final RegistryInterface<Feature<?>> FEATURES = XPlatform.INSTANCE.registryInterface(Registry.f_122839_);
        public static final RegistryHolder<ImprovedFreezeTopLayerFeature> FREEZE_TOP_LAYER = Features.register("freeze_top_layer", ImprovedFreezeTopLayerFeature::new, NoneFeatureConfiguration.f_67815_);
        public static final RegistryHolder<ImprovedIceSpikeFeature> ICE_SPIKES = Features.register("ice_spikes", ImprovedIceSpikeFeature::new, NoneFeatureConfiguration.f_67815_);
        public static final RegistryHolder<DiskFeature> DISK = Features.register("disk", DiskFeature::new, DiskConfiguration.f_67618_);

        private static <C extends FeatureConfiguration, F extends Feature<C>> RegistryHolder<F> register(String name, Function<Codec<C>, F> feature, Codec<C> codec) {
            return FEATURES.register(name, () -> (Feature)feature.apply(codec));
        }
    }
}

