/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.util;

import com.alcatrazescapee.primalwinter.epsilon.EpsilonUtil;
import com.alcatrazescapee.primalwinter.epsilon.ParseError;
import com.alcatrazescapee.primalwinter.epsilon.Spec;
import com.alcatrazescapee.primalwinter.epsilon.SpecBuilder;
import com.alcatrazescapee.primalwinter.epsilon.Type;
import com.alcatrazescapee.primalwinter.epsilon.value.BoolValue;
import com.alcatrazescapee.primalwinter.epsilon.value.FloatValue;
import com.alcatrazescapee.primalwinter.epsilon.value.IntValue;
import com.alcatrazescapee.primalwinter.epsilon.value.TypeValue;
import com.alcatrazescapee.primalwinter.platform.XPlatform;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public enum Config {
    INSTANCE;

    private static final Logger LOGGER;
    public final BoolValue enableWeatherCommand;
    public final BoolValue enableSnowAccumulationDuringWorldgen;
    public final BoolValue enableSnowAccumulationDuringWeather;
    public final TypeValue<List<ResourceLocation>> nonWinterBiomes;
    public final TypeValue<List<ResourceKey<Level>>> nonWinterDimensions;
    public final BoolValue invertNonWinterBiomes;
    public final BoolValue invertNonWinterDimensions;
    public final FloatValue fogDensity;
    public final IntValue snowDensity;
    public final BoolValue windSounds;
    public final BoolValue snowSounds;
    public final IntValue fogColorDay;
    public final IntValue fogColorNight;
    public final BoolValue weatherRenderChanges;
    public final BoolValue skyRenderChanges;
    private final Spec spec;

    private Config() {
        SpecBuilder builder = Spec.builder();
        builder.comment("This is the config file for the Primal Winter mod", "In order to reload these settings in-game, you must run /primalwinterReloadConfig").push("general");
        this.enableWeatherCommand = builder.comment("Should the vanilla /weather be disabled? Any changes require a world restart to take effect.").define("enableWeatherCommand", false);
        this.enableSnowAccumulationDuringWorldgen = builder.comment("If true, snow will be layered higher than one layer during world generation.", "Note: due to snow layers being > 1 block tall, this tends to prevent most passive (and hostile) mob spawning on the surface, since there are no places to spawn.").define("enableSnowAccumulationDuringWorldgen", false);
        this.enableSnowAccumulationDuringWeather = builder.comment("If true, snow will be layered higher than one layer during weather (snow).").define("enableSnowAccumulationDuringWeather", true);
        this.nonWinterBiomes = builder.comment("A list of biome IDs that will not be forcibly converted to frozen wastelands. Any changes requires a MC restart to take effect.").define("nonWinterBiomes", Stream.of(Biomes.f_48209_, Biomes.f_48200_, Biomes.f_48201_, Biomes.f_48175_, Biomes.f_48199_, Biomes.f_48165_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48210_, Biomes.f_48173_).map(ResourceKey::m_135782_).toList(), Type.STRING_LIST.map(list -> list.stream().map(name -> ParseError.require(() -> new ResourceLocation(name))).toList(), list -> list.stream().map(ResourceLocation::toString).toList(), TypeValue::new));
        this.nonWinterDimensions = builder.comment("A list of dimension IDs that will not have winter weather effects set.").define("nonWinterDimensions", List.of(Level.f_46429_, Level.f_46430_), Type.STRING_LIST.map(list -> list.stream().map(name -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ParseError.require(() -> new ResourceLocation(name)))).toList(), list -> list.stream().map(rl -> rl.m_135782_().toString()).toList(), TypeValue::new));
        this.invertNonWinterBiomes = builder.comment("If true, the 'nonWinterBiomes' config option will be interpreted as a list of winter biomes, and all others will be ignored.").define("invertNonWinterBiomes", false);
        this.invertNonWinterDimensions = builder.comment("If true, the 'nonWinterDimensions' config option will be interpreted as a list of winter dimensions, and all others will be ignored.").define("invertNonWinterDimensions", false);
        builder.swap("client");
        this.fogDensity = builder.comment("How dense the fog effect during a snowstorm is.").define("fogDensity", 0.1f, 0.0f, 1.0f);
        this.snowDensity = builder.comment("How visually dense the snow weather effect is. Normally, vanilla sets this to 5 with fast graphics, and 10 with fancy graphics.").define("snowDensity", 15, 1, 15);
        this.snowSounds = builder.comment("Enable snow (actually rain) weather sounds.").define("snowSounds", true);
        this.windSounds = builder.comment("Enable wind / snow storm weather sounds.").define("windSounds", true);
        this.fogColorDay = builder.comment("This is the fog color during the day. It must be an RGB hex string.").define("fogColorDay", 12566488, Type.STRING.map(str -> ParseError.require(() -> Integer.parseInt(str, 16)), value -> String.format("%06x", value), IntValue::new));
        this.fogColorNight = builder.comment("This is the fog color during the night. It must be an RGB hex string.").define("fogColorNight", 789529, Type.STRING.map(str -> ParseError.require(() -> Integer.parseInt(str, 16)), value -> String.format("%06x", value), IntValue::new));
        this.weatherRenderChanges = builder.comment("Changes the weather renderer to one which renders faster, denser snow.").define("weatherRenderChanges", true);
        this.skyRenderChanges = builder.comment("Changes the sky renderer to one which does not render sunrise or sunset effects during a snowstorm.").define("skyRenderChanges", true);
        this.spec = builder.pop().build();
    }

    public void load() {
        LOGGER.info("Loading Primal Winter Config");
        EpsilonUtil.parse(this.spec, Path.of(XPlatform.INSTANCE.configDir().toString(), "primalwinter.toml"), arg_0 -> ((Logger)LOGGER).warn(arg_0));
    }

    public boolean isWinterDimension(ResourceKey<Level> dimension) {
        Stream stream = Config.INSTANCE.nonWinterDimensions.get().stream();
        return Config.INSTANCE.invertNonWinterDimensions.getAsBoolean() ? stream.anyMatch(arg_0 -> dimension.equals(arg_0)) : stream.noneMatch(arg_0 -> dimension.equals(arg_0));
    }

    public boolean isWinterBiome(@Nullable ResourceLocation name) {
        if (name != null) {
            Stream stream = Config.INSTANCE.nonWinterBiomes.get().stream();
            return Config.INSTANCE.invertNonWinterBiomes.getAsBoolean() ? stream.anyMatch(arg_0 -> ((ResourceLocation)name).equals(arg_0)) : stream.noneMatch(arg_0 -> ((ResourceLocation)name).equals(arg_0));
        }
        return false;
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

