/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.gui.screen;

import com.hungteen.pvz.client.cache.ClientPlayerResources;
import com.hungteen.pvz.client.gui.screen.AbstractOptionScreen;
import com.hungteen.pvz.client.gui.search.SearchCategories;
import com.hungteen.pvz.client.gui.search.SearchOption;
import com.hungteen.pvz.common.container.AlmanacContainer;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.appease.GatlingPeaEntity;
import com.hungteen.pvz.common.entity.plant.appease.PeaShooterEntity;
import com.hungteen.pvz.common.entity.plant.appease.RepeaterEntity;
import com.hungteen.pvz.common.entity.plant.appease.ThreePeaterEntity;
import com.hungteen.pvz.common.entity.plant.assist.GraveBusterEntity;
import com.hungteen.pvz.common.entity.plant.enforce.ChomperEntity;
import com.hungteen.pvz.common.entity.plant.enforce.SquashEntity;
import com.hungteen.pvz.common.entity.plant.enforce.TangleKelpEntity;
import com.hungteen.pvz.common.entity.plant.explosion.CherryBombEntity;
import com.hungteen.pvz.common.entity.plant.explosion.DoomShroomEntity;
import com.hungteen.pvz.common.entity.plant.explosion.PotatoMineEntity;
import com.hungteen.pvz.common.entity.plant.flame.JalapenoEntity;
import com.hungteen.pvz.common.entity.plant.ice.IceShroomEntity;
import com.hungteen.pvz.common.entity.plant.ice.SnowPeaEntity;
import com.hungteen.pvz.common.entity.plant.light.SunFlowerEntity;
import com.hungteen.pvz.common.entity.plant.light.SunShroomEntity;
import com.hungteen.pvz.common.entity.plant.light.TwinSunFlowerEntity;
import com.hungteen.pvz.common.entity.plant.magic.CoffeeBeanEntity;
import com.hungteen.pvz.common.entity.plant.magic.HypnoShroomEntity;
import com.hungteen.pvz.common.entity.plant.magic.MariGoldEntity;
import com.hungteen.pvz.common.entity.plant.spear.SpikeWeedEntity;
import com.hungteen.pvz.common.entity.plant.toxic.FumeShroomEntity;
import com.hungteen.pvz.common.entity.plant.toxic.PuffShroomEntity;
import com.hungteen.pvz.common.entity.plant.toxic.ScaredyShroomEntity;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.RenderUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AlmanacScreen
extends AbstractOptionScreen<AlmanacContainer> {
    public static final ResourceLocation TEXTURE = StringUtil.prefix("textures/gui/container/almanac.png");
    private int propertyCnt;

    public AlmanacScreen(AlmanacContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_146999_f = 240;
        this.field_147000_g = 200;
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.renderAlmanac(stack);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    @Override
    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    protected void renderAlmanac(MatrixStack stack) {
        if (!this.searchGui.getCurrentOption().isPresent()) {
            return;
        }
        SearchOption option = this.searchGui.getCurrentOption().get();
        this.renderTitle(stack, option);
        if (!this.isOptionUnLocked(option)) {
            return;
        }
        this.renderLogo(stack, option);
        this.renderXpBar(stack, option);
        this.renderShortInfo(stack, option);
        option.getPlant().ifPresent(plant -> {
            int lvl = ClientPlayerResources.getPlayerPlantCardLvl(plant);
            this.propertyCnt = 0;
            World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
            this.drawProperty(stack, Properties.SUN_COST, PlantUtil.getPlantSunCost(plant));
            this.drawProperty(stack, Properties.COOL_DOWN, PlantUtil.getPlantCoolDownTime(plant, lvl));
            if (plant.isBlockPlant) {
                return;
            }
            if (plant.isOuterPlant) {
                this.drawProperty(stack, Properties.HEALTH, 400.0f);
                return;
            }
            PVZPlantEntity plantEntity = PlantUtil.getPlantEntity(world, plant);
            plantEntity.setPlantLvl(lvl);
            this.drawProperty(stack, Properties.HEALTH, plantEntity.getPlantHealth());
            switch (plant) {
                case PEA_SHOOTER: {
                    PeaShooterEntity peaShooter = (PeaShooterEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, peaShooter.getAttackDamage());
                    this.drawProperty(stack, Properties.BULLET_SPEED, peaShooter.getBulletSpeed());
                    break;
                }
                case SUN_FLOWER: {
                    SunFlowerEntity sunFlower = (SunFlowerEntity)plantEntity;
                    this.drawProperty(stack, Properties.GEN_AMOUNT, sunFlower.getSunAmount());
                    break;
                }
                case CHERRY_BOMB: {
                    CherryBombEntity cherryBomb = (CherryBombEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, cherryBomb.getAttackDamage());
                    break;
                }
                case WALL_NUT: {
                    break;
                }
                case POTATO_MINE: {
                    PotatoMineEntity potatoMine = (PotatoMineEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, potatoMine.getAttackDamage());
                    break;
                }
                case SNOW_PEA: {
                    SnowPeaEntity snowPea = (SnowPeaEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, snowPea.getAttackDamage());
                    this.drawProperty(stack, Properties.BULLET_SPEED, snowPea.getBulletSpeed());
                    this.drawProperty(stack, Properties.COLD_EFFECT, snowPea.getColdLvl());
                    this.drawProperty(stack, Properties.COLD_EFFECT_TIME, snowPea.getColdTick());
                    break;
                }
                case CHOMPER: {
                    ChomperEntity chomper = (ChomperEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, chomper.getAttackDamage());
                    this.drawProperty(stack, Properties.ATTACK_CD, chomper.getRestCD());
                    break;
                }
                case REPEATER: {
                    RepeaterEntity repeater = (RepeaterEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, repeater.getAttackDamage());
                    this.drawProperty(stack, Properties.BULLET_SPEED, repeater.getBulletSpeed());
                    break;
                }
                case PUFF_SHROOM: {
                    PuffShroomEntity puffShroom = (PuffShroomEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, puffShroom.getAttackDamage());
                    break;
                }
                case SUN_SHROOM: {
                    SunShroomEntity sunShroom = (SunShroomEntity)plantEntity;
                    this.drawProperty(stack, Properties.GEN_AMOUNT, sunShroom.getSunAmountInStage(2));
                    break;
                }
                case FUME_SHROOM: {
                    FumeShroomEntity fumeShroom = (FumeShroomEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, fumeShroom.getAttackDamage());
                    break;
                }
                case GRAVE_BUSTER: {
                    GraveBusterEntity graveBuster = (GraveBusterEntity)plantEntity;
                    this.drawProperty(stack, Properties.KILL_COUNT, graveBuster.getMaxKillCnt());
                    break;
                }
                case HYPNO_SHROOM: {
                    HypnoShroomEntity hypnoShroom = (HypnoShroomEntity)plantEntity;
                    this.drawProperty(stack, Properties.HEAL_HEALTH, hypnoShroom.getHealHealth());
                    break;
                }
                case SCAREDY_SHROOM: {
                    ScaredyShroomEntity scaredyShroom = (ScaredyShroomEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, scaredyShroom.getAttackDamage());
                    this.drawProperty(stack, Properties.SCARE_RANGE, scaredyShroom.getScareDistance());
                    break;
                }
                case ICE_SHROOM: {
                    IceShroomEntity iceShroom = (IceShroomEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, iceShroom.getAttackDamage());
                    this.drawProperty(stack, Properties.FROZEN_EFFECT_TIME, iceShroom.getFrozenTick());
                    this.drawProperty(stack, Properties.COLD_EFFECT, iceShroom.getColdLvl());
                    this.drawProperty(stack, Properties.COLD_EFFECT_TIME, iceShroom.getColdTick());
                    break;
                }
                case DOOM_SHROOM: {
                    DoomShroomEntity doomShroom = (DoomShroomEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, doomShroom.getAttackDamage());
                    break;
                }
                case LILY_PAD: {
                    break;
                }
                case SQUASH: {
                    SquashEntity squash = (SquashEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, squash.getAttackDamage());
                    this.drawProperty(stack, Properties.DEATH_CHANCE, (float)squash.getDeathChance() * 1.0f / 100.0f);
                    break;
                }
                case THREE_PEATER: {
                    ThreePeaterEntity threePeater = (ThreePeaterEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, threePeater.getAttackDamage());
                    this.drawProperty(stack, Properties.BULLET_SPEED, threePeater.getBulletSpeed());
                    break;
                }
                case TANGLE_KELP: {
                    TangleKelpEntity tangleKelp = (TangleKelpEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, tangleKelp.getAttackDamage());
                    break;
                }
                case JALAPENO: {
                    JalapenoEntity jalapeno = (JalapenoEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, jalapeno.getAttackDamage());
                    break;
                }
                case SPIKE_WEED: {
                    SpikeWeedEntity spikeWeed = (SpikeWeedEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, spikeWeed.getAttackDamage());
                    this.drawProperty(stack, Properties.ATTACK_CD, spikeWeed.getAttackCD());
                    break;
                }
                case TORCH_WOOD: {
                    break;
                }
                case TALL_NUT: {
                    break;
                }
                case PUMPKIN: {
                    break;
                }
                case COFFEE_BEAN: {
                    CoffeeBeanEntity coffeeBean = (CoffeeBeanEntity)plantEntity;
                    this.drawProperty(stack, Properties.DURATION, coffeeBean.getAwakeTime());
                    break;
                }
                case MARIGOLD: {
                    MariGoldEntity marigold = (MariGoldEntity)plantEntity;
                    this.drawProperty(stack, Properties.AVE_GEN_AMOUNT, marigold.getAveGenAmount());
                    break;
                }
                case GATLING_PEA: {
                    GatlingPeaEntity gatlingPea = (GatlingPeaEntity)plantEntity;
                    this.drawProperty(stack, Properties.ATTACK_DAMAGE, gatlingPea.getAttackDamage());
                    this.drawProperty(stack, Properties.BULLET_SPEED, gatlingPea.getBulletSpeed());
                    break;
                }
                case TWIN_SUNFLOWER: {
                    TwinSunFlowerEntity twinSunflower = (TwinSunFlowerEntity)plantEntity;
                    this.drawProperty(stack, Properties.GEN_AMOUNT, twinSunflower.getSunAmount() * 2);
                    break;
                }
                case WATER_GUARD: {
                    break;
                }
                default: {
                    System.out.println("Warning: forget to fill the almanac info");
                }
            }
        });
        option.getZombie().ifPresent(zombie -> {});
        if (option.isPlayer()) {
            int sunNum = ClientPlayerResources.getPlayerStats(Resources.SUN_NUM);
            int energyNum = ClientPlayerResources.getPlayerStats(Resources.ENERGY_NUM);
            int money = ClientPlayerResources.getPlayerStats(Resources.MONEY);
            int gemNum = ClientPlayerResources.getPlayerStats(Resources.GEM_NUM);
            this.propertyCnt = 0;
            this.drawProperty(stack, Properties.SUN_NUM, sunNum);
            this.drawProperty(stack, Properties.ENERGY_NUM, energyNum);
            this.drawProperty(stack, Properties.MONEY, money);
            this.drawProperty(stack, Properties.GEM_NUM, gemNum);
        }
    }

    protected void drawProperty(MatrixStack stack, Properties prop, float num) {
        ++this.propertyCnt;
        int posX = this.field_147003_i + 9 + 2 + ((this.propertyCnt & 1) == 1 ? 0 : 110);
        int posY = this.field_147009_r + 92 + 2 + (this.propertyCnt - 1) / 2 * 18;
        String string = prop.getName() + ": ";
        int floorNum = MathHelper.func_76140_b((double)num);
        string = (float)floorNum == num ? string + floorNum : string + num;
        StringUtil.drawScaledString(stack, this.field_230712_o_, string, posX, posY, prop.getColor(), 1.0f);
    }

    protected void renderShortInfo(MatrixStack stack, SearchOption a) {
        if (a.isPlayer()) {
            return;
        }
        stack.func_227860_a_();
        stack.func_227865_b_();
    }

    protected void renderXpBar(MatrixStack stack, SearchOption a) {
        int maxXp;
        int xp;
        stack.func_227860_a_();
        int maxLvl = 1;
        int lvl = 1;
        Plants p = null;
        if (a.isPlant()) {
            p = a.getPlant().get();
            maxLvl = PlantUtil.getPlantMaxLvl(p);
            lvl = ClientPlayerResources.getPlayerPlantCardLvl(p);
        } else if (a.isPlayer()) {
            maxLvl = 100;
            lvl = ClientPlayerResources.getPlayerStats(Resources.TREE_LVL);
        }
        String lvlInfo = Properties.LVL.getName() + ":" + lvl;
        int barWidth = 62;
        int barHeight = 9;
        int len = barWidth;
        if (maxLvl != lvl && p != null) {
            xp = ClientPlayerResources.getPlayerPlantCardXp(p);
            maxXp = PlantUtil.getPlantLevelUpXp(p, lvl);
            len = RenderUtil.getRenderBarLen(xp, maxXp, barWidth);
        } else if (a.isPlayer()) {
            xp = ClientPlayerResources.getPlayerStats(Resources.TREE_XP);
            maxXp = PlayerUtil.getPlayerLevelUpXp(lvl);
            len = RenderUtil.getRenderBarLen(xp, maxXp, barWidth);
        }
        int texX = 0;
        int texY = maxLvl == lvl ? 210 : 200;
        stack.func_227860_a_();
        stack.func_227861_a_(0.0, 0.0, 100.0);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(stack, this.field_147003_i + 9, this.field_147009_r + 66, texX, texY, len, barHeight);
        StringUtil.drawCenteredScaledString(stack, this.field_230712_o_, lvlInfo, this.field_147003_i + 9 + barWidth / 2, this.field_147009_r + 66 + 1, 0, 1.0f);
        stack.func_227865_b_();
        stack.func_227865_b_();
    }

    protected void renderTitle(MatrixStack stack, SearchOption a) {
        stack.func_227860_a_();
        int dx = this.field_147003_i + 82 + 75;
        int dy = this.field_147009_r + 10 + 2;
        StringUtil.drawCenteredScaledString(stack, this.field_230712_o_, SearchOption.getOptionName(a).getString(), dx, dy, 39168, 1.6f);
        stack.func_227865_b_();
    }

    protected void renderLogo(MatrixStack stack, SearchOption a) {
        int dx = this.field_147003_i + 16;
        int dy = this.field_147009_r + 14;
        int scale = 3;
        RenderSystem.pushMatrix();
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderSystem.translated((double)((double)(dx % scale) * 1.0 / (double)scale), (double)((double)(dy % scale) * 1.0 / (double)scale), (double)0.0);
        this.field_230707_j_.func_175042_a(SearchOption.getItemStackByOption(a), dx / scale, dy / scale);
        RenderSystem.popMatrix();
    }

    @Override
    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(stack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public boolean isOptionUnLocked(SearchOption option) {
        return ClientPlayerResources.isAlmanacUnLocked(option);
    }

    @Override
    public List<SearchCategories> getSearchCategories() {
        return Arrays.asList(SearchCategories.ALL, SearchCategories.PLANTS, SearchCategories.ZOMBIES);
    }

    private static enum Properties {
        LVL,
        HEALTH,
        SUN_COST,
        COOL_DOWN,
        ATTACK_DAMAGE,
        GEN_TIME,
        GEN_AMOUNT,
        AVE_GEN_AMOUNT,
        ATTACK_CD,
        PRE_TIME,
        ARMOR_HEALTH,
        SUN_NUM,
        ENERGY_NUM,
        MONEY,
        GEM_NUM,
        BULLET_SPEED,
        COLD_EFFECT,
        COLD_EFFECT_TIME,
        FROZEN_EFFECT_TIME,
        DEATH_CHANCE,
        ATTACK_RANGE,
        LIVE_TICK,
        KILL_COUNT,
        HEAL_HEALTH,
        SCARE_RANGE,
        DURATION;


        public String getName() {
            return new TranslationTextComponent("gui.pvz.almanac." + this.toString().toLowerCase()).getString();
        }

        public int getColor() {
            switch (this) {
                default: 
            }
            return 0;
        }
    }
}

