/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.gui.screen;

import com.hungteen.pvz.client.cache.ClientPlayerResources;
import com.hungteen.pvz.common.container.SlotMachineContainer;
import com.hungteen.pvz.common.network.ClickButtonPacket;
import com.hungteen.pvz.common.network.PVZPacketHandler;
import com.hungteen.pvz.common.tileentity.SlotMachineTileEntity;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlotMachineScreen
extends ContainerScreen<SlotMachineContainer> {
    private static final ResourceLocation TEXTURE = StringUtil.prefix("textures/gui/container/slot_machine.png");
    protected Button craftButton;

    public SlotMachineScreen(SlotMachineContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 176;
        this.field_147000_g = 227;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.craftButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 79, this.field_147009_r + 120, 18, 18, (ITextComponent)new TranslationTextComponent("gui.pvz.slot_machine"), button -> {
            if (this.craftButton.field_230694_p_) {
                PVZPacketHandler.CHANNEL.sendToServer((Object)new ClickButtonPacket(6, 0, 0));
            }
        }));
        this.craftButton.field_230694_p_ = false;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.craftButton.field_230694_p_ = this.canLottery();
        this.renderSlotMachine(stack);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    private void renderSlotMachine(MatrixStack stack) {
        RenderSystem.pushMatrix();
        float percent = (float)((SlotMachineContainer)this.field_147002_h).te.array.func_221476_a(12) * 1.0f / (float)((SlotMachineContainer)this.field_147002_h).te.array.func_221476_a(15);
        RenderSystem.translated((double)0.0, (double)((1.0f - percent) * 18.0f), (double)0.0);
        int currentPos = ((SlotMachineContainer)this.field_147002_h).te.array.func_221476_a(13);
        for (int i = 0; i < 4; ++i) {
            int row = (currentPos + i - 2 + 4) % 4;
            for (int j = 0; j < 3; ++j) {
                SlotMachineTileEntity.SlotOptions option = SlotMachineTileEntity.OPTION_LIST.get(((SlotMachineContainer)this.field_147002_h).te.array.func_221476_a(3 * row + j));
                int x = this.field_147003_i + 62 + 18 * j;
                int y = this.field_147009_r + 58 - 18 * i;
                if (option.plantType.isPresent()) {
                    Plants plant = option.plantType.get();
                    ItemStack itemstack = new ItemStack((IItemProvider)PlantUtil.getPlantEnjoyCard(plant));
                    RenderSystem.pushMatrix();
                    this.field_230707_j_.field_77023_b -= 100.0f;
                    this.field_230707_j_.func_180450_b(itemstack, x, y);
                    this.field_230707_j_.field_77023_b += 100.0f;
                    RenderSystem.popMatrix();
                    continue;
                }
                if (option.isJewel) {
                    RenderSystem.pushMatrix();
                    this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
                    this.func_238474_b_(stack, x, y, 176, 0, 16, 16);
                    RenderSystem.popMatrix();
                    continue;
                }
                if (!option.isSun) continue;
                RenderSystem.pushMatrix();
                RenderSystem.enableBlend();
                this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
                this.func_238474_b_(stack, x, y, 176, 16, 16, 16);
                RenderSystem.popMatrix();
            }
        }
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)120.0);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(stack, this.field_147003_i + 61, this.field_147009_r + 74, 61, 74, 54, 21);
        this.func_238474_b_(stack, this.field_147003_i + 61, this.field_147009_r + 1, 61, 1, 54, 21);
        StringUtil.drawScaledString(stack, this.field_230712_o_, new TranslationTextComponent("block.pvz.slot_machine").getString(), this.field_147003_i + 5, this.field_147009_r + 6, 0, 1.0f);
        StringUtil.drawScaledString(stack, this.field_230712_o_, new TranslationTextComponent("gui.pvz.slot_machine.left").func_240702_b_(":" + ClientPlayerResources.getPlayerStats(Resources.LOTTERY_CHANCE)).getString(), this.field_147003_i + this.field_146999_f / 2 + 25, this.field_147009_r + 6, 0, 1.0f);
        StringUtil.drawScaledString(stack, this.field_230712_o_, new TranslationTextComponent("gui.pvz.slot_machine.sun").func_240702_b_(":" + ClientPlayerResources.getPlayerStats(Resources.SUN_NUM)).getString(), this.field_147003_i + 12, this.field_147009_r + 125, 0, 0.8f);
        StringUtil.drawScaledString(stack, this.field_230712_o_, new TranslationTextComponent("gui.pvz.slot_machine.cost").func_240702_b_(":25").getString(), this.field_147003_i + this.field_146999_f / 2 + 15, this.field_147009_r + 125, 0, 0.8f);
        RenderSystem.popMatrix();
    }

    private boolean canLottery() {
        return ClientPlayerResources.getPlayerStats(Resources.SUN_NUM) >= 25 && ClientPlayerResources.getPlayerStats(Resources.LOTTERY_CHANCE) > 0 && ((SlotMachineContainer)this.field_147002_h).te.array.func_221476_a(14) == 1;
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        stack.func_227860_a_();
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(stack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        stack.func_227865_b_();
    }
}

