/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.model.entity.plant;

import com.hungteen.pvz.api.interfaces.IPVZPlant;
import com.hungteen.pvz.client.model.entity.plant.IPlantModel;
import com.hungteen.pvz.client.model.entity.plant.appease.AngelStarFruitModel;
import com.hungteen.pvz.client.model.entity.plant.appease.PeaShooterModel;
import com.hungteen.pvz.client.model.entity.plant.appease.RepeaterModel;
import com.hungteen.pvz.client.model.entity.plant.appease.SplitPeaModel;
import com.hungteen.pvz.client.model.entity.plant.appease.StarFruitModel;
import com.hungteen.pvz.client.model.entity.plant.appease.ThreePeaterModel;
import com.hungteen.pvz.client.model.entity.plant.arma.CabbagePultModel;
import com.hungteen.pvz.client.model.entity.plant.arma.KernelPultModel;
import com.hungteen.pvz.client.model.entity.plant.arma.MelonPultModel;
import com.hungteen.pvz.client.model.entity.plant.assist.BloverModel;
import com.hungteen.pvz.client.model.entity.plant.assist.FlowerPotModel;
import com.hungteen.pvz.client.model.entity.plant.assist.GoldMagnetModel;
import com.hungteen.pvz.client.model.entity.plant.assist.GraveBusterModel;
import com.hungteen.pvz.client.model.entity.plant.assist.LilyPadModel;
import com.hungteen.pvz.client.model.entity.plant.assist.MagnetShroomModel;
import com.hungteen.pvz.client.model.entity.plant.defence.GarlicModel;
import com.hungteen.pvz.client.model.entity.plant.defence.PumpkinModel;
import com.hungteen.pvz.client.model.entity.plant.defence.TallNutModel;
import com.hungteen.pvz.client.model.entity.plant.defence.WallNutModel;
import com.hungteen.pvz.client.model.entity.plant.defence.WaterGuardModel;
import com.hungteen.pvz.client.model.entity.plant.enforce.BonkChoyModel;
import com.hungteen.pvz.client.model.entity.plant.enforce.ChomperModel;
import com.hungteen.pvz.client.model.entity.plant.enforce.SquashModel;
import com.hungteen.pvz.client.model.entity.plant.enforce.TangleKelpModel;
import com.hungteen.pvz.client.model.entity.plant.enforce.UmbrellaLeafModel;
import com.hungteen.pvz.client.model.entity.plant.explosion.BambooLordModel;
import com.hungteen.pvz.client.model.entity.plant.explosion.CherryBombModel;
import com.hungteen.pvz.client.model.entity.plant.explosion.CobCannonModel;
import com.hungteen.pvz.client.model.entity.plant.explosion.DoomShroomModel;
import com.hungteen.pvz.client.model.entity.plant.explosion.PotatoMineModel;
import com.hungteen.pvz.client.model.entity.plant.flame.JalapenoModel;
import com.hungteen.pvz.client.model.entity.plant.flame.TorchWoodModel;
import com.hungteen.pvz.client.model.entity.plant.ice.IceShroomModel;
import com.hungteen.pvz.client.model.entity.plant.ice.IcebergLettuceModel;
import com.hungteen.pvz.client.model.entity.plant.ice.SnowPeaModel;
import com.hungteen.pvz.client.model.entity.plant.ice.WinterMelonModel;
import com.hungteen.pvz.client.model.entity.plant.light.GoldLeafModel;
import com.hungteen.pvz.client.model.entity.plant.light.PlanternModel;
import com.hungteen.pvz.client.model.entity.plant.light.SunFlowerModel;
import com.hungteen.pvz.client.model.entity.plant.light.SunShroomModel;
import com.hungteen.pvz.client.model.entity.plant.magic.CoffeeBeanModel;
import com.hungteen.pvz.client.model.entity.plant.magic.HypnoShroomModel;
import com.hungteen.pvz.client.model.entity.plant.magic.ImitaterModel;
import com.hungteen.pvz.client.model.entity.plant.magic.MariGoldModel;
import com.hungteen.pvz.client.model.entity.plant.magic.StrangeCatModel;
import com.hungteen.pvz.client.model.entity.plant.spear.CactusModel;
import com.hungteen.pvz.client.model.entity.plant.spear.CatTailModel;
import com.hungteen.pvz.client.model.entity.plant.spear.SpikeRockModel;
import com.hungteen.pvz.client.model.entity.plant.spear.SpikeWeedModel;
import com.hungteen.pvz.client.model.entity.plant.toxic.FumeShroomModel;
import com.hungteen.pvz.client.model.entity.plant.toxic.GloomShroomModel;
import com.hungteen.pvz.client.model.entity.plant.toxic.PuffShroomModel;
import com.hungteen.pvz.client.model.entity.plant.toxic.ScaredyShroomModel;
import com.hungteen.pvz.client.model.entity.plant.toxic.SeaShroomModel;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlantModelHandler {
    public static final Map<Plants, IPlantModel<? extends IPVZPlant>> PLANT_PART1_MODEL = new EnumMap<Plants, IPlantModel<? extends IPVZPlant>>(Plants.class);
    public static final Map<Plants, IPlantModel<? extends IPVZPlant>> PLANT_PART2_MODEL = new EnumMap<Plants, IPlantModel<? extends IPVZPlant>>(Plants.class);

    public static Optional<IPlantModel<? extends IPVZPlant>> getPart1Model(Plants plant) {
        return Optional.ofNullable(PLANT_PART1_MODEL.get((Object)plant));
    }

    public static Optional<IPlantModel<? extends IPVZPlant>> getPart2Model(Plants plant) {
        return Optional.ofNullable(PLANT_PART2_MODEL.get((Object)plant));
    }

    private static void putModel(Plants plant, Supplier<? extends IPlantModel<? extends IPVZPlant>> sup) {
        PLANT_PART1_MODEL.put(plant, sup.get());
        PLANT_PART2_MODEL.put(plant, sup.get());
    }

    static {
        PlantModelHandler.putModel(Plants.PEA_SHOOTER, PeaShooterModel::new);
        PlantModelHandler.putModel(Plants.SUN_FLOWER, SunFlowerModel::new);
        PlantModelHandler.putModel(Plants.CHERRY_BOMB, CherryBombModel::new);
        PlantModelHandler.putModel(Plants.WALL_NUT, WallNutModel::new);
        PlantModelHandler.putModel(Plants.POTATO_MINE, PotatoMineModel::new);
        PlantModelHandler.putModel(Plants.SNOW_PEA, SnowPeaModel::new);
        PlantModelHandler.putModel(Plants.CHOMPER, ChomperModel::new);
        PlantModelHandler.putModel(Plants.REPEATER, RepeaterModel::new);
        PlantModelHandler.putModel(Plants.PUFF_SHROOM, PuffShroomModel::new);
        PlantModelHandler.putModel(Plants.SUN_SHROOM, SunShroomModel::new);
        PlantModelHandler.putModel(Plants.FUME_SHROOM, FumeShroomModel::new);
        PlantModelHandler.putModel(Plants.GRAVE_BUSTER, GraveBusterModel::new);
        PlantModelHandler.putModel(Plants.HYPNO_SHROOM, HypnoShroomModel::new);
        PlantModelHandler.putModel(Plants.SCAREDY_SHROOM, ScaredyShroomModel::new);
        PlantModelHandler.putModel(Plants.ICE_SHROOM, IceShroomModel::new);
        PlantModelHandler.putModel(Plants.DOOM_SHROOM, DoomShroomModel::new);
        PlantModelHandler.putModel(Plants.LILY_PAD, LilyPadModel::new);
        PlantModelHandler.putModel(Plants.SQUASH, SquashModel::new);
        PlantModelHandler.putModel(Plants.THREE_PEATER, ThreePeaterModel::new);
        PlantModelHandler.putModel(Plants.TANGLE_KELP, TangleKelpModel::new);
        PlantModelHandler.putModel(Plants.JALAPENO, JalapenoModel::new);
        PlantModelHandler.putModel(Plants.SPIKE_WEED, SpikeWeedModel::new);
        PlantModelHandler.putModel(Plants.TORCH_WOOD, TorchWoodModel::new);
        PlantModelHandler.putModel(Plants.TALL_NUT, TallNutModel::new);
        PlantModelHandler.putModel(Plants.SEA_SHROOM, SeaShroomModel::new);
        PlantModelHandler.putModel(Plants.PLANTERN, PlanternModel::new);
        PlantModelHandler.putModel(Plants.CACTUS, CactusModel::new);
        PlantModelHandler.putModel(Plants.BLOVER, BloverModel::new);
        PlantModelHandler.putModel(Plants.SPLIT_PEA, SplitPeaModel::new);
        PlantModelHandler.putModel(Plants.STAR_FRUIT, StarFruitModel::new);
        PlantModelHandler.putModel(Plants.PUMPKIN, PumpkinModel::new);
        PlantModelHandler.putModel(Plants.MAGNET_SHROOM, MagnetShroomModel::new);
        PlantModelHandler.putModel(Plants.CABBAGE_PULT, CabbagePultModel::new);
        PlantModelHandler.putModel(Plants.FLOWER_POT, FlowerPotModel::new);
        PlantModelHandler.putModel(Plants.KERNEL_PULT, KernelPultModel::new);
        PlantModelHandler.putModel(Plants.COFFEE_BEAN, CoffeeBeanModel::new);
        PlantModelHandler.putModel(Plants.GARLIC, GarlicModel::new);
        PlantModelHandler.putModel(Plants.UMBRELLA_LEAF, UmbrellaLeafModel::new);
        PlantModelHandler.putModel(Plants.MARIGOLD, MariGoldModel::new);
        PlantModelHandler.putModel(Plants.MELON_PULT, MelonPultModel::new);
        PlantModelHandler.putModel(Plants.GATLING_PEA, PuffShroomModel::new);
        PlantModelHandler.putModel(Plants.TWIN_SUNFLOWER, SunShroomModel::new);
        PlantModelHandler.putModel(Plants.GLOOM_SHROOM, GloomShroomModel::new);
        PlantModelHandler.putModel(Plants.CAT_TAIL, CatTailModel::new);
        PlantModelHandler.putModel(Plants.WINTER_MELON, WinterMelonModel::new);
        PlantModelHandler.putModel(Plants.GOLD_MAGNET, GoldMagnetModel::new);
        PlantModelHandler.putModel(Plants.SPIKE_ROCK, SpikeRockModel::new);
        PlantModelHandler.putModel(Plants.COB_CANNON, CobCannonModel::new);
        PlantModelHandler.putModel(Plants.IMITATER, ImitaterModel::new);
        PlantModelHandler.putModel(Plants.WATER_GUARD, WaterGuardModel::new);
        PlantModelHandler.putModel(Plants.STRANGE_CAT, StrangeCatModel::new);
        PlantModelHandler.putModel(Plants.ANGEL_STAR_FRUIT, AngelStarFruitModel::new);
        PlantModelHandler.putModel(Plants.GOLD_LEAF, GoldLeafModel::new);
        PlantModelHandler.putModel(Plants.EXPLODE_O_NUT, WallNutModel::new);
        PlantModelHandler.putModel(Plants.GIANT_WALL_NUT, WallNutModel::new);
        PlantModelHandler.putModel(Plants.BUTTER_PULT, KernelPultModel::new);
        PlantModelHandler.putModel(Plants.BAMBOO_LORD, BambooLordModel::new);
        PlantModelHandler.putModel(Plants.ICEBERG_LETTUCE, IcebergLettuceModel::new);
        PlantModelHandler.putModel(Plants.BONK_CHOY, BonkChoyModel::new);
    }
}

