/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.model.entity.plant;

import com.hungteen.pvz.client.model.entity.plant.PVZPlantModel;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.utils.AnimationUtil;
import java.util.Optional;
import net.minecraft.client.renderer.model.ModelRenderer;

public abstract class PlantShooterModel<T extends PlantShooterEntity>
extends PVZPlantModel<T> {
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.getHeadModel().ifPresent(m -> {
            m.field_78795_f = 0.0f;
        });
        this.getBodyModel().ifPresent(m -> {
            m.field_78795_f = 0.0f;
        });
        if (((PVZPlantEntity)entity).isPlantInSuperMode()) {
            int T = 10;
            int tick = ((PVZPlantEntity)entity).getSuperTime() % 10;
            if (tick >= 0) {
                this.getHeadModel().ifPresent(m -> {
                    m.field_78795_f = AnimationUtil.getUpDownUpDown(tick, 10.0f, this.getMaxRotAngle() / 5.0f);
                });
                this.getBodyModel().ifPresent(m -> {
                    m.field_78795_f = AnimationUtil.getUpDownUpDown(tick, 10.0f, -this.getMaxRotAngle() / 5.0f);
                });
            }
        } else {
            int T = 10;
            int tick = ((PlantShooterEntity)entity).getShootTick() + 10 - ((PlantShooterEntity)entity).getShootCD();
            if (tick >= 0) {
                this.getHeadModel().ifPresent(m -> {
                    m.field_78795_f = AnimationUtil.getUpDownUpDown(tick, 10.0f, this.getMaxRotAngle());
                });
                this.getBodyModel().ifPresent(m -> {
                    m.field_78795_f = AnimationUtil.getUpDownUpDown(tick, 10.0f, -this.getMaxRotAngle());
                });
            }
        }
    }

    public float getMaxRotAngle() {
        return 15.0f;
    }

    public Optional<ModelRenderer> getHeadModel() {
        return Optional.empty();
    }

    public Optional<ModelRenderer> getBodyModel() {
        return Optional.empty();
    }
}

