/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.model.entity.zombie;

import com.hungteen.pvz.client.model.entity.zombie.IZombieModel;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.body.ZombieDropBodyEntity;
import com.hungteen.pvz.utils.AnimationUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Optional;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public abstract class PVZZombieModel<T extends PVZZombieEntity>
extends EntityModel<T>
implements IZombieModel<T> {
    protected static final float HAND_MAX_ANGLE = AnimationUtil.byDegree(-120.0f);
    protected static final int MAX_ANIM_CD = 10;
    protected boolean isLeftHandFree = true;
    protected boolean isRightHandFree = true;
    protected boolean isHeadFree = true;
    protected float rightHandOriginAngel = 0.0f;

    @Override
    public void tickPartAnim(ZombieDropBodyEntity entity, ZombieDropBodyEntity.BodyType type, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        switch (type) {
            case BODY: {
                int cd = 20;
                if (entity.getAnimTime() < cd) {
                    this.getZombieWholeBody().field_78795_f = AnimationUtil.getUp(entity.getAnimTime(), cd, 90.0f);
                    this.getZombieRightHand().field_78795_f = AnimationUtil.byDegree(this.rightHandOriginAngel) - AnimationUtil.getUp(entity.getAnimTime(), cd, 180.0f + this.rightHandOriginAngel);
                    if (!entity.hasHandDefence()) break;
                    this.getZombieLeftHand().field_78795_f = AnimationUtil.byDegree(this.rightHandOriginAngel) - AnimationUtil.getUp(entity.getAnimTime(), cd, 180.0f + this.rightHandOriginAngel);
                    break;
                }
                this.getZombieWholeBody().field_78795_f = AnimationUtil.byDegree(90.0f);
                this.getZombieRightHand().field_78795_f = AnimationUtil.byDegree(-180.0f);
                if (!entity.hasHandDefence()) break;
                this.getZombieLeftHand().field_78795_f = AnimationUtil.byDegree(-180.0f);
                break;
            }
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.refreshAnim();
        this.updateFreeParts(entity);
        this.doWalkAnimation(limbSwing, limbSwingAmount, netHeadYaw, headPitch);
        this.performAttack(entity);
    }

    public void refreshAnim() {
    }

    public void updateFreeParts(T entity) {
        this.getZombieLeftHand().field_78806_j = ((PVZZombieEntity)entity).hasHand();
        this.getZombieHead().field_78806_j = ((PVZZombieEntity)entity).hasHead();
    }

    protected void doWalkAnimation(float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch) {
        this.getZombieHead().field_78796_g = netHeadYaw / 57.295776f;
        this.getZombieHead().field_78795_f = headPitch / 57.295776f;
        this.getZombieLeftLeg().field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.getZombieRightLeg().field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        if (this.isRightHandFree) {
            this.getZombieRightHand().field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        if (this.isLeftHandFree) {
            this.getZombieLeftHand().field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
    }

    protected void performAttack(T entity) {
        if (((PVZZombieEntity)entity).getAnimTime() > 0) {
            if (this.isLeftHandFree || this.isRightHandFree) {
                this.doHandEat(entity);
            }
        } else if (this.isZombieAngry(entity)) {
            this.doPreAttackPose();
        }
    }

    protected void doPreAttackPose() {
        if (this.isLeftHandFree || this.isRightHandFree) {
            if (this.isLeftHandFree) {
                this.getZombieLeftHand().field_78795_f = HAND_MAX_ANGLE;
            }
            if (this.isRightHandFree) {
                this.getZombieRightHand().field_78795_f = HAND_MAX_ANGLE;
            }
        }
    }

    protected void doHandEat(T entity) {
        if (this.isLeftHandFree) {
            this.getZombieLeftHand().field_78795_f = HAND_MAX_ANGLE - AnimationUtil.getUpDown(10 - ((PVZZombieEntity)entity).getAnimTime(), 10.0f, -70.0f);
        }
        if (this.isRightHandFree) {
            this.getZombieRightHand().field_78795_f = HAND_MAX_ANGLE - AnimationUtil.getUpDown(10 - ((PVZZombieEntity)entity).getAnimTime(), 10.0f, -70.0f);
        }
    }

    protected boolean isZombieAngry(T entity) {
        return entity.func_213398_dR();
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.getZombieWholeBody().func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
    }

    @Override
    public void renderBody(ZombieDropBodyEntity entity, MatrixStack stack, IVertexBuilder buffer, int packedLight, int packedOverlay, ZombieDropBodyEntity.BodyType type) {
        switch (type) {
            case HAND: {
                this.getZombieLeftHand().field_78806_j = true;
                this.getZombieLeftHand().func_78793_a(0.0f, 24.0f, 0.0f);
                this.getZombieLeftHand().field_78795_f = 0.0f;
                this.getZombieLeftHand().func_228308_a_(stack, buffer, packedLight, packedOverlay);
                break;
            }
            case HEAD: {
                this.getZombieHead().field_78806_j = true;
                this.getHelmet().ifPresent(m -> {
                    m.field_78806_j = false;
                });
                this.getZombieHead().func_78793_a(0.0f, 24.0f, 0.0f);
                this.getZombieHead().func_228308_a_(stack, buffer, packedLight, packedOverlay);
                break;
            }
            case BODY: {
                this.getZombieLeftHand().field_78806_j = entity.hasHandDefence();
                this.getZombieHead().field_78806_j = false;
                this.getHandDefence().ifPresent(m -> {
                    m.field_78806_j = entity.hasHandDefence();
                });
                this.getZombieWholeBody().func_228308_a_(stack, buffer, packedLight, packedOverlay);
                break;
            }
        }
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public EntityModel<T> getZombieModel() {
        return this;
    }

    public Optional<ModelRenderer> getHelmet() {
        return Optional.empty();
    }

    public Optional<ModelRenderer> getHandDefence() {
        return Optional.empty();
    }

    public abstract ModelRenderer getZombieLeftHand();

    public abstract ModelRenderer getZombieRightHand();

    public abstract ModelRenderer getZombieLeftLeg();

    public abstract ModelRenderer getZombieRightLeg();

    public abstract ModelRenderer getZombieHead();

    public abstract ModelRenderer getZombieUpBody();

    public abstract ModelRenderer getZombieWholeBody();
}

