/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.render.entity.plant;

import com.hungteen.pvz.client.render.entity.plant.PlantRenderHandler;
import com.hungteen.pvz.client.render.layer.PlantLadderLayer;
import com.hungteen.pvz.client.render.layer.PumpkinLayer;
import com.hungteen.pvz.client.render.layer.fullskin.CharmLayer;
import com.hungteen.pvz.client.render.layer.fullskin.EnergyLayer;
import com.hungteen.pvz.client.render.layer.fullskin.HealLightLayer;
import com.hungteen.pvz.client.render.layer.fullskin.SunLightLayer;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.utils.AnimationUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class PVZPlantRender<T extends PVZPlantEntity>
extends MobRenderer<T, EntityModel<T>> {
    private static final int BREATH_ANIM_CD = 40;

    public PVZPlantRender(EntityRendererManager rendererManager, EntityModel<T> entityModelIn, float shadowSizeIn) {
        super(rendererManager, entityModelIn, shadowSizeIn);
        this.addPlantLayers();
    }

    protected void scale(T plant, MatrixStack matrixStackIn, float partialTickTime) {
        int live = ((PVZPlantEntity)plant).getExistTick() % 40;
        float scaleOffset = AnimationUtil.upDown(live, 40.0f, 0.01f);
        float sz1 = this.getScaleByEntity(plant);
        float sz = sz1 * (1.0f + scaleOffset);
        Vector3d vec = this.getTranslateVec(plant);
        matrixStackIn.func_227862_a_(sz, sz, sz);
        matrixStackIn.func_227861_a_(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    protected void addPlantLayers() {
        this.func_177094_a(new EnergyLayer(this));
        this.func_177094_a(new CharmLayer(this));
        this.func_177094_a(new PumpkinLayer(this));
        this.func_177094_a(new SunLightLayer(this));
        this.func_177094_a(new HealLightLayer(this));
        this.func_177094_a(new PlantLadderLayer(this));
    }

    public float getScaleByEntity(T entity) {
        return PlantRenderHandler.getPlantScale(entity.getPlantEnumName());
    }

    public Vector3d getTranslateVec(T entity) {
        return new Vector3d(0.0, 0.0, 0.0);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return PlantRenderHandler.getPlantTex(entity.getPlantEnumName()).orElse(PlantRenderHandler.PEA_SHOOTER_TEX);
    }
}

