/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.render.entity.plant;

import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;

public class PlantRenderHandler {
    public static final Map<Plants, ResourceLocation> PLANT_TEX = new EnumMap<Plants, ResourceLocation>(Plants.class);
    public static final Map<Plants, Float> PLANT_SCALE = new EnumMap<Plants, Float>(Plants.class);
    public static final ResourceLocation PEA_SHOOTER_TEX = PlantRenderHandler.get(Plants.PEA_SHOOTER, 1.0f);
    public static final ResourceLocation SUN_FLOWER_TEX = PlantRenderHandler.get(Plants.SUN_FLOWER);
    public static final ResourceLocation CHERRY_BOMB_TEX = PlantRenderHandler.get(Plants.CHERRY_BOMB);
    public static final ResourceLocation WALL_NUT_TEX = PlantRenderHandler.get(Plants.WALL_NUT, 0.4f);
    public static final ResourceLocation POTATO_MINE_TEX = PlantRenderHandler.get(Plants.POTATO_MINE, 0.6f);
    public static final ResourceLocation SNOW_PEA_TEX = PlantRenderHandler.get(Plants.SNOW_PEA, 1.0f);
    public static final ResourceLocation CHOMPER_TEX = PlantRenderHandler.get(Plants.CHOMPER, 0.85f);
    public static final ResourceLocation REPEATER_TEX = PlantRenderHandler.get(Plants.REPEATER, 1.0f);
    public static final ResourceLocation PUFF_SHROOM_TEX = PlantRenderHandler.get(Plants.PUFF_SHROOM, 0.6f);
    public static final ResourceLocation SUN_SHROOM_TEX = PlantRenderHandler.get(Plants.SUN_SHROOM, 0.4f);
    public static final ResourceLocation FUME_SHROOM_TEX = PlantRenderHandler.get(Plants.FUME_SHROOM, 0.9f);
    public static final ResourceLocation GRAVE_BUSTER_TEX = PlantRenderHandler.get(Plants.GRAVE_BUSTER, 1.0f);
    public static final ResourceLocation HYPNO_SHROOM_TEX = PlantRenderHandler.get(Plants.HYPNO_SHROOM, 0.6f);
    public static final ResourceLocation SCAREDY_SHROOM_TEX = PlantRenderHandler.get(Plants.SCAREDY_SHROOM, 0.7f);
    public static final ResourceLocation ICE_SHROOM_TEX = PlantRenderHandler.get(Plants.ICE_SHROOM, 0.82f);
    public static final ResourceLocation DOOM_SHROOM_TEX = PlantRenderHandler.get(Plants.DOOM_SHROOM, 1.0f);
    public static final ResourceLocation LILY_PAD_TEX = PlantRenderHandler.get(Plants.LILY_PAD, 1.0f);
    public static final ResourceLocation SQUASH_TEX = PlantRenderHandler.get(Plants.SQUASH, 0.5f);
    public static final ResourceLocation THREE_PEATER_TEX = PlantRenderHandler.get(Plants.THREE_PEATER, 0.99f);
    public static final ResourceLocation TANGLE_KELP_TEX = PlantRenderHandler.get(Plants.TANGLE_KELP, 0.6f);
    public static final ResourceLocation JALAPENO_TEX = PlantRenderHandler.get(Plants.JALAPENO, 0.5f);
    public static final ResourceLocation SPIKE_WEED_TEX = PlantRenderHandler.get(Plants.SPIKE_WEED, 0.5f);
    public static final ResourceLocation TORCH_WOOD_TEX = PlantRenderHandler.get(Plants.TORCH_WOOD, 0.5f);
    public static final ResourceLocation TALL_NUT_TEX = PlantRenderHandler.get(Plants.TALL_NUT, 0.4f);
    public static final ResourceLocation SEA_SHROOM_TEX = PlantRenderHandler.get(Plants.SEA_SHROOM, 0.6f);
    public static final ResourceLocation PLANTERN_TEX = PlantRenderHandler.get(Plants.PLANTERN, 0.7f);
    public static final ResourceLocation CACTUS_TEX = PlantRenderHandler.get(Plants.CACTUS, 1.0f);
    public static final ResourceLocation BLOVER_TEX = PlantRenderHandler.get(Plants.BLOVER, 1.2f);
    public static final ResourceLocation SPLIT_PEA_TEX = PlantRenderHandler.get(Plants.SPLIT_PEA, 1.0f);
    public static final ResourceLocation STAR_FRUIT_TEX = PlantRenderHandler.get(Plants.STAR_FRUIT, 0.82f);
    public static final ResourceLocation PUMPKIN_TEX = PlantRenderHandler.get(Plants.PUMPKIN, 0.6f);
    public static final ResourceLocation MAGNET_SHROOM_TEX = PlantRenderHandler.get(Plants.MAGNET_SHROOM, 1.2f);
    public static final ResourceLocation CABBAGE_PULT_TEX = PlantRenderHandler.get(Plants.CABBAGE_PULT, 0.9f);
    public static final ResourceLocation FLOWER_POT_TEX = PlantRenderHandler.get(Plants.FLOWER_POT, 0.85f);
    public static final ResourceLocation KERNEL_PULT_TEX = PlantRenderHandler.get(Plants.KERNEL_PULT, 0.9f);
    public static final ResourceLocation COFFEE_BEAN_TEX = PlantRenderHandler.get(Plants.COFFEE_BEAN, 0.6f);
    public static final ResourceLocation GARLIC_TEX = PlantRenderHandler.get(Plants.GARLIC, 0.9f);
    public static final ResourceLocation UMBRELLA_LEAF_TEX = PlantRenderHandler.get(Plants.UMBRELLA_LEAF, 0.8f);
    public static final ResourceLocation MARIGOLD_TEX = PlantRenderHandler.get(Plants.MARIGOLD, 0.5f);
    public static final ResourceLocation MELON_PULT_TEX = PlantRenderHandler.get(Plants.MELON_PULT, 0.9f);
    public static final ResourceLocation GATLING_PEA_TEX = PlantRenderHandler.get(Plants.GATLING_PEA, 0.5f);
    public static final ResourceLocation TWIN_SUNFLOWER_TEX = PlantRenderHandler.get(Plants.TWIN_SUNFLOWER, 0.45f);
    public static final ResourceLocation GLOOM_SHROOM_TEX = PlantRenderHandler.get(Plants.GLOOM_SHROOM, 1.0f);
    public static final ResourceLocation CAT_TAIL_TEX = PlantRenderHandler.get(Plants.CAT_TAIL, 0.18f);
    public static final ResourceLocation WINTER_MELON_TEX = PlantRenderHandler.get(Plants.WINTER_MELON, 0.9f);
    public static final ResourceLocation GOLD_MAGNET_TEX = PlantRenderHandler.get(Plants.GOLD_MAGNET, 1.2f);
    public static final ResourceLocation SPIKE_ROCK = PlantRenderHandler.get(Plants.SPIKE_ROCK, 0.5f);
    public static final ResourceLocation COB_CANNON_TEX = PlantRenderHandler.get(Plants.COB_CANNON, 1.1f);
    public static final ResourceLocation IMITATER_TEX = PlantRenderHandler.get(Plants.IMITATER, 0.9f);
    public static final ResourceLocation WATER_GUARD_TEX = PlantRenderHandler.get(Plants.WATER_GUARD, 0.8f);
    public static final ResourceLocation STRANGE_CAT_TEX = PlantRenderHandler.get(Plants.STRANGE_CAT, 0.18f);
    public static final ResourceLocation ANGEL_STAR_FRUIT_TEX = PlantRenderHandler.get(Plants.ANGEL_STAR_FRUIT, 0.8f);
    public static final ResourceLocation GOLD_LEAF_TEX = PlantRenderHandler.get(Plants.GOLD_LEAF, 0.8f);
    public static final ResourceLocation EXPLODE_O_NUT_TEX = PlantRenderHandler.get(Plants.EXPLODE_O_NUT, 0.4f);
    public static final ResourceLocation GIANT_WALL_NUT_TEX = PlantRenderHandler.get(Plants.GIANT_WALL_NUT, 1.0f);
    public static final ResourceLocation BUTTER_PULT_TEX = PlantRenderHandler.get(Plants.BUTTER_PULT, 0.9f);
    public static final ResourceLocation BAMBOO_LORD_TEX = PlantRenderHandler.get(Plants.BAMBOO_LORD, 1.0f);
    public static final ResourceLocation ICEBERG_LETTUCE_TEX = PlantRenderHandler.get(Plants.ICEBERG_LETTUCE, 0.5f);
    public static final ResourceLocation BONK_CHOY_TEX = PlantRenderHandler.get(Plants.BONK_CHOY, 0.9f);

    private static ResourceLocation get(Plants plant) {
        return PlantRenderHandler.get(plant, 0.5f);
    }

    private static ResourceLocation get(Plants plant, float scale) {
        String sep = PlantUtil.getPlantEssenceType(plant).toString().toLowerCase();
        ResourceLocation res = StringUtil.prefix("textures/entity/plant/" + sep + "/" + plant.toString().toLowerCase() + ".png");
        PlantRenderHandler.put(plant, res, scale);
        return res;
    }

    public static Optional<ResourceLocation> getPlantTex(Plants plant) {
        return Optional.ofNullable(PLANT_TEX.get((Object)plant));
    }

    public static float getPlantScale(Plants plant) {
        return PLANT_SCALE.getOrDefault((Object)plant, Float.valueOf(0.5f)).floatValue();
    }

    private static void put(Plants plant, ResourceLocation res, float scale) {
        PLANT_TEX.put(plant, res);
        PLANT_SCALE.put(plant, Float.valueOf(scale));
    }
}

