/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.render.entity.plant.explosion;

import com.hungteen.pvz.client.model.entity.plant.explosion.PotatoMineModel;
import com.hungteen.pvz.client.render.entity.plant.PVZPlantRender;
import com.hungteen.pvz.common.entity.plant.explosion.PotatoMineEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PotatoMineRender
extends PVZPlantRender<PotatoMineEntity> {
    public PotatoMineRender(EntityRendererManager rendererManager) {
        super(rendererManager, new PotatoMineModel(), 0.3f);
    }

    @Override
    public float getScaleByEntity(PotatoMineEntity entity) {
        float sz = super.getScaleByEntity(entity);
        if (entity.isMineReady()) {
            float scale = 0.15f;
            return sz + (float)entity.getAttackTime() * 0.15f / (float)entity.getAttackCD();
        }
        return sz;
    }

    @Override
    public Vector3d getTranslateVec(PotatoMineEntity entity) {
        float offsetY = 0.6f;
        if (entity.isRisingFromDirt()) {
            int time = 240 - entity.getExistTick();
            return new Vector3d(0.0, (double)((float)time * 0.6f / 20.0f), 0.0);
        }
        return entity.isMineReady() ? new Vector3d(0.0, 0.0, 0.0) : new Vector3d(0.0, (double)0.6f, 0.0);
    }
}

