/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.render.entity.plant.light;

import com.hungteen.pvz.client.model.entity.plant.light.SunShroomModel;
import com.hungteen.pvz.client.render.entity.plant.PVZPlantRender;
import com.hungteen.pvz.common.entity.plant.light.SunShroomEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SunShroomRender
extends PVZPlantRender<SunShroomEntity> {
    public SunShroomRender(EntityRendererManager rendererManager) {
        super(rendererManager, new SunShroomModel(), 0.3f);
    }

    @Override
    public float getScaleByEntity(SunShroomEntity entity) {
        float smallSize = 0.2f;
        float bigSize = 0.35f;
        int T = 10;
        int tick = entity.getExistTick();
        if (tick <= 20) {
            return 0.2f;
        }
        if (entity.isInGrowStage(3)) {
            // empty if block
        }
        if (entity.isInGrowStage(2)) {
            return 0.35f;
        }
        if (entity.isInGrowStage(1)) {
            int now = tick + 10 - 24000;
            return now >= 0 ? 0.2f + 0.14999999f * (float)now / 10.0f : 0.2f;
        }
        return 0.2f;
    }
}

