/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.render.entity.plant.toxic;

import com.hungteen.pvz.client.model.entity.plant.toxic.PuffShroomModel;
import com.hungteen.pvz.client.render.entity.plant.PVZPlantRender;
import com.hungteen.pvz.common.entity.plant.toxic.PuffShroomEntity;
import com.hungteen.pvz.utils.AnimationUtil;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PuffShroomRender
extends PVZPlantRender<PuffShroomEntity> {
    public PuffShroomRender(EntityRendererManager rendererManager) {
        super(rendererManager, new PuffShroomModel(), 0.3f);
    }

    @Override
    public float getScaleByEntity(PuffShroomEntity entity) {
        float changeSize = 0.05f;
        float size = super.getScaleByEntity(entity);
        if (entity.isPlantInSuperMode()) {
            int T = 10;
            int tick = entity.getSuperTime() % 10;
            return size + AnimationUtil.upDown(tick, 10.0f, 0.05f);
        }
        int T = 10;
        int tick = entity.getShootTick() + 10 - entity.getShootCD();
        return tick >= 0 ? size + AnimationUtil.upDown(tick, 10.0f, 0.05f) : size;
    }
}

