/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.client.render.entity.zombie;

import com.hungteen.pvz.client.cache.ClientPlayerResources;
import com.hungteen.pvz.client.render.entity.PVZCreatureRender;
import com.hungteen.pvz.client.render.entity.zombie.ZombieRenderHandler;
import com.hungteen.pvz.client.render.layer.fullskin.CharmLayer;
import com.hungteen.pvz.client.render.layer.fullskin.EnergyLayer;
import com.hungteen.pvz.client.render.layer.fullskin.SunLayer;
import com.hungteen.pvz.client.render.layer.fullskin.SunLightLayer;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;

public abstract class PVZZombieRender<T extends PVZZombieEntity>
extends PVZCreatureRender<T> {
    public static final float MINI_SCALE = 0.32f;

    public PVZZombieRender(EntityRendererManager rendererManager, EntityModel<T> entityModelIn, float shadowSizeIn) {
        super(rendererManager, entityModelIn, shadowSizeIn);
        this.addZombieLayers();
    }

    protected boolean isBodyVisible(T livingEntityIn) {
        return super.func_225622_a_(livingEntityIn) || ClientPlayerResources.lightLevel > 1;
    }

    protected void addZombieLayers() {
        this.func_177094_a(new EnergyLayer(this));
        this.func_177094_a(new CharmLayer(this));
        this.func_177094_a(new SunLightLayer(this));
        this.func_177094_a(new SunLayer(this));
    }

    @Override
    public Vector3d getTranslateVec(T entity) {
        float height = this.getOffsetRisingHeight();
        float downOffset = ((PVZZombieEntity)entity).getAnimTime() < 0 ? (float)(-((PVZZombieEntity)entity).getAnimTime()) * 1.0f / 30.0f * height : 0.0f;
        return new Vector3d(0.0, (double)downOffset, 0.0);
    }

    @Override
    protected float getScaleByEntity(T entity) {
        float sz = ZombieRenderHandler.getZombieScale(entity.getZombieEnumName());
        return ((PVZZombieEntity)entity).isMiniZombie() ? sz * 0.32f : sz;
    }

    protected float getOffsetRisingHeight() {
        return 1.6f;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ZombieRenderHandler.getZombieTex(entity.getZombieEnumName()).orElse(ZombieRenderHandler.NORMAL_ZOMBIE_TEX);
    }
}

