/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.capability.player;

import com.hungteen.pvz.common.advancement.trigger.MoneyTrigger;
import com.hungteen.pvz.common.advancement.trigger.PlantLevelTrigger;
import com.hungteen.pvz.common.advancement.trigger.SunAmountTrigger;
import com.hungteen.pvz.common.advancement.trigger.TreeLevelTrigger;
import com.hungteen.pvz.common.container.shop.MysteryShopContainer;
import com.hungteen.pvz.common.event.events.PlayerLevelUpEvent;
import com.hungteen.pvz.common.network.PVZPacketHandler;
import com.hungteen.pvz.common.network.PlantStatsPacket;
import com.hungteen.pvz.common.network.PlayerStatsPacket;
import com.hungteen.pvz.utils.ConfigUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;

public class PlayerDataManager {
    private final PlayerEntity player;
    private final PlayerStats playerStats;
    private final PlantStats plantStats;
    private final ItemCDStats itemCDStats;
    private final OtherStats otherStats;

    public PlayerDataManager(PlayerEntity player) {
        this.player = player;
        this.playerStats = new PlayerStats();
        this.plantStats = new PlantStats();
        this.itemCDStats = new ItemCDStats(this);
        this.otherStats = new OtherStats(this);
    }

    public CompoundNBT saveToNBT() {
        CompoundNBT baseTag = new CompoundNBT();
        this.playerStats.saveToNBT(baseTag);
        this.plantStats.saveToNBT(baseTag);
        this.itemCDStats.saveToNBT(baseTag);
        this.otherStats.saveToNBT(baseTag);
        return baseTag;
    }

    public void loadFromNBT(CompoundNBT baseTag) {
        this.playerStats.loadFromNBT(baseTag);
        this.plantStats.loadFromNBT(baseTag);
        this.itemCDStats.loadFromNBT(baseTag);
        this.otherStats.loadFromNBT(baseTag);
    }

    public void cloneFromExistingPlayerData(PlayerDataManager data) {
        int i;
        for (Resources resources : Resources.values()) {
            this.playerStats.resources.put(resources, data.playerStats.resources.get((Object)resources));
        }
        for (Enum enum_ : Plants.values()) {
            this.plantStats.plantLevel.put(enum_, data.plantStats.plantLevel.get(enum_));
            this.plantStats.plantXp.put(enum_, data.plantStats.plantXp.get(enum_));
        }
        for (Enum enum_ : Plants.values()) {
            this.itemCDStats.setPlantCardCD((Plants)enum_, data.itemCDStats.getPlantCardCoolDown((Plants)enum_));
            this.itemCDStats.setPlantCardBar((Plants)enum_, data.itemCDStats.getPlantCardBarLength((Plants)enum_));
        }
        for (i = 0; i < 5; ++i) {
            this.otherStats.zombieWaveTime[i] = data.otherStats.zombieWaveTime[i];
        }
        this.otherStats.totalWaveCount = data.otherStats.totalWaveCount;
        this.otherStats.playSoundTick = data.otherStats.playSoundTick;
        for (i = 0; i < 8; ++i) {
            this.otherStats.mysteryGoods[i] = data.otherStats.mysteryGoods[i];
        }
        this.otherStats.updateGoodTick = data.otherStats.updateGoodTick;
    }

    public PlayerStats getPlayerStats() {
        return this.playerStats;
    }

    public PlantStats getPlantStats() {
        return this.plantStats;
    }

    public ItemCDStats getItemCDStats() {
        return this.itemCDStats;
    }

    public OtherStats getOtherStats() {
        return this.otherStats;
    }

    public final class OtherStats {
        private final PlayerDataManager manager;
        public int[] zombieWaveTime = new int[5];
        public int[] mysteryGoods = new int[8];
        public int totalWaveCount;
        public int playSoundTick;
        public int updateGoodTick;
        public int lightLevel;

        public OtherStats(PlayerDataManager manager) {
            this.manager = manager;
            for (int i = 0; i < this.zombieWaveTime.length; ++i) {
                this.zombieWaveTime[i] = 0;
            }
            this.totalWaveCount = 0;
            this.playSoundTick = 0;
            this.lightLevel = 0;
            MysteryShopContainer.genNextGoods(PlayerDataManager.this.player);
        }

        private void saveToNBT(CompoundNBT baseTag) {
            CompoundNBT statsNBT = new CompoundNBT();
            for (int i = 0; i < this.zombieWaveTime.length; ++i) {
                statsNBT.func_74768_a("zombieWaveTime_" + i, this.zombieWaveTime[i]);
            }
            baseTag.func_218657_a("zombie_wave_time", (INBT)statsNBT);
            baseTag.func_74768_a("total_wave_cnt", this.totalWaveCount);
            baseTag.func_74768_a("base_sound_tick", this.playSoundTick);
            CompoundNBT tmp = new CompoundNBT();
            for (int i = 0; i < this.mysteryGoods.length; ++i) {
                tmp.func_74768_a("mystery_good_" + i, this.mysteryGoods[i]);
            }
            baseTag.func_218657_a("mystery_goods", (INBT)tmp);
            baseTag.func_74768_a("update_good_tick", this.updateGoodTick);
        }

        private void loadFromNBT(CompoundNBT baseTag) {
            int i;
            CompoundNBT nbt;
            if (baseTag.func_74764_b("zombie_wave_time")) {
                nbt = baseTag.func_74775_l("zombie_wave_time");
                for (i = 0; i < this.zombieWaveTime.length; ++i) {
                    this.zombieWaveTime[i] = nbt.func_74762_e("zombieWaveTime_" + i);
                }
            }
            if (baseTag.func_74764_b("total_wave_cnt")) {
                this.totalWaveCount = baseTag.func_74762_e("total_wave_cnt");
            }
            if (baseTag.func_74764_b("base_sound_tick")) {
                this.playSoundTick = baseTag.func_74762_e("base_sound_tick");
            }
            if (baseTag.func_74764_b("mystery_goods")) {
                nbt = baseTag.func_74775_l("mystery_goods");
                for (i = 0; i < this.mysteryGoods.length; ++i) {
                    this.mysteryGoods[i] = nbt.func_74762_e("mystery_good_" + i);
                }
            }
            if (baseTag.func_74764_b("update_good_tick")) {
                this.updateGoodTick = baseTag.func_74762_e("update_good_tick");
            }
        }
    }

    public final class ItemCDStats {
        private final PlayerDataManager manager;
        private EnumMap<Plants, Integer> plantCardCD = new EnumMap(Plants.class);
        private EnumMap<Plants, Float> plantCardBar = new EnumMap(Plants.class);

        public ItemCDStats(PlayerDataManager manager) {
            this.manager = manager;
            for (Plants plant : Plants.values()) {
                this.plantCardCD.put(plant, 0);
                this.plantCardBar.put(plant, Float.valueOf(0.0f));
            }
        }

        public void setPlantCardCD(Plants plant, int tick) {
            this.plantCardCD.put(plant, tick);
        }

        public int getPlantCardCoolDown(Plants plant) {
            return this.plantCardCD.get((Object)plant);
        }

        public void setPlantCardBar(Plants plant, float bar) {
            this.plantCardBar.put(plant, Float.valueOf(bar));
        }

        public float getPlantCardBarLength(Plants plant) {
            return this.plantCardBar.get((Object)plant).floatValue();
        }

        public int getPlantCardCD(Plants plant) {
            return (int)(this.plantCardBar.get((Object)plant).floatValue() * (float)this.plantCardCD.get((Object)plant).intValue());
        }

        private void saveToNBT(CompoundNBT baseTag) {
            CompoundNBT statsNBT = new CompoundNBT();
            for (Plants p : Plants.values()) {
                statsNBT.func_74768_a(p.toString().toLowerCase() + "_plant_card_cd", this.plantCardCD.get((Object)p).intValue());
                statsNBT.func_74776_a(p.toString().toLowerCase() + "_plant_card_bar", this.plantCardBar.get((Object)p).floatValue());
            }
            baseTag.func_218657_a("plant_card_item_cd", (INBT)statsNBT);
        }

        private void loadFromNBT(CompoundNBT baseTag) {
            if (baseTag.func_74764_b("plant_card_item_cd")) {
                CompoundNBT statsTag = baseTag.func_74775_l("plant_card_item_cd");
                for (Plants p : Plants.values()) {
                    if (statsTag.func_74764_b(p.toString().toLowerCase() + "_plant_card_cd")) {
                        this.setPlantCardCD(p, statsTag.func_74762_e(p.toString().toLowerCase() + "_plant_card_cd"));
                    }
                    if (!statsTag.func_74764_b(p.toString().toLowerCase() + "_plant_card_bar")) continue;
                    this.setPlantCardBar(p, statsTag.func_74760_g(p.toString().toLowerCase() + "_plant_card_bar"));
                }
            }
        }
    }

    public final class PlantStats {
        private HashMap<Plants, Integer> plantXp = new HashMap(Plants.values().length);
        private HashMap<Plants, Integer> plantLevel = new HashMap(Plants.values().length);

        private PlantStats() {
            for (Plants plant : Plants.values()) {
                this.plantXp.put(plant, 0);
                this.plantLevel.put(plant, 1);
            }
        }

        public int getPlantLevel(Plants plant) {
            return this.plantLevel.get((Object)plant);
        }

        public int getPlantXp(Plants plant) {
            return this.plantXp.get((Object)plant);
        }

        public void addPlantLevel(Plants plant, int lvl) {
            int now = this.getPlantLevel(plant) + lvl;
            int maxLvl = PlantUtil.getPlantMaxLvl(plant);
            now = MathHelper.func_76125_a((int)now, (int)1, (int)maxLvl);
            this.plantLevel.put(plant, now);
            PlantLevelTrigger.INSTANCE.trigger((ServerPlayerEntity)PlayerDataManager.this.player, now);
            this.sendPlantPacket(PlayerDataManager.this.player, plant);
        }

        public void addPlantXp(Plants plant, int num) {
            int xp;
            int lvl = this.getPlantLevel(plant);
            if (num > 0) {
                int needXp = PlantUtil.getPlantLevelUpXp(plant, lvl);
                int maxLvl = PlantUtil.getPlantMaxLvl(plant);
                for (xp = this.getPlantXp(plant) + num; lvl < maxLvl && xp >= needXp; xp -= needXp) {
                    this.addPlantLevel(plant, 1);
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerLevelUpEvent.PlantLevelUpEvent(PlayerDataManager.this.player, plant, ++lvl));
                    needXp = PlantUtil.getPlantLevelUpXp(plant, lvl);
                }
                if (lvl == maxLvl) {
                    xp = 0;
                }
            } else {
                while (lvl > 1 && xp < 0) {
                    this.addPlantLevel(plant, -1);
                    lvl = this.getPlantLevel(plant);
                    int needXp = PlantUtil.getPlantLevelUpXp(plant, lvl);
                    xp += needXp;
                }
                if (lvl == 1 && xp < 0) {
                    xp = 0;
                }
            }
            this.plantXp.put(plant, xp);
            this.sendPlantPacket(PlayerDataManager.this.player, plant);
        }

        public void sendPlantPacket(PlayerEntity player, Plants plant) {
            if (player instanceof ServerPlayerEntity) {
                PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlantStatsPacket(plant.ordinal(), this.plantLevel.get((Object)plant), this.plantXp.get((Object)plant)));
            }
        }

        private void saveToNBT(CompoundNBT baseTag) {
            for (Plants plant : Plants.values()) {
                CompoundNBT plantNBT = new CompoundNBT();
                plantNBT.func_74768_a("player_plant_lvl", this.getPlantLevel(plant));
                plantNBT.func_74768_a("player_plant_exp", this.getPlantXp(plant));
                baseTag.func_218657_a(plant.toString(), (INBT)plantNBT);
            }
        }

        private void loadFromNBT(CompoundNBT baseTag) {
            for (Plants plant : Plants.values()) {
                CompoundNBT plantTag = (CompoundNBT)baseTag.func_74781_a(plant.toString());
                if (plantTag == null) continue;
                if (plantTag.func_74764_b("player_plant_lvl")) {
                    this.plantLevel.put(plant, plantTag.func_74762_e("player_plant_lvl"));
                }
                if (!plantTag.func_74764_b("player_plant_exp")) continue;
                this.plantXp.put(plant, plantTag.func_74762_e("player_plant_exp"));
            }
        }
    }

    public final class PlayerStats {
        private HashMap<Resources, Integer> resources = new HashMap(Resources.values().length);

        private PlayerStats() {
            for (Resources res : Resources.values()) {
                if (res == Resources.SUN_NUM) {
                    this.resources.put(res, 50);
                    continue;
                }
                if (res == Resources.LOTTERY_CHANCE) {
                    this.resources.put(res, 10);
                    continue;
                }
                if (res == Resources.GROUP_TYPE) {
                    this.resources.put(res, ConfigUtil.getPlayerInitialGroup());
                    continue;
                }
                if (res == Resources.NO_FOG_TICK) {
                    this.resources.put(res, 0);
                    continue;
                }
                this.resources.put(res, res.min);
            }
        }

        public int getPlayerStats(Resources res) {
            return this.resources.get((Object)res);
        }

        public void setPlayerStats(Resources res, int num) {
            this.resources.put(res, num);
            this.addPlayerStats(res, 0);
        }

        public void addPlayerStats(Resources res, int num) {
            switch (res) {
                case TREE_LVL: {
                    int now = MathHelper.func_76125_a((int)(this.resources.get((Object)Resources.TREE_LVL) + num), (int)1, (int)100);
                    this.resources.put(Resources.TREE_LVL, now);
                    this.addPlayerStats(Resources.SUN_NUM, 0);
                    TreeLevelTrigger.INSTANCE.trigger((ServerPlayerEntity)PlayerDataManager.this.player, now);
                    break;
                }
                case TREE_XP: {
                    this.addTreeXp(num);
                    break;
                }
                case SUN_NUM: {
                    int now = MathHelper.func_76125_a((int)(this.resources.get((Object)Resources.SUN_NUM) + num), (int)0, (int)PlayerUtil.getPlayerMaxSunNum(this.resources.get((Object)Resources.TREE_LVL)));
                    this.resources.put(Resources.SUN_NUM, now);
                    SunAmountTrigger.INSTANCE.trigger((ServerPlayerEntity)PlayerDataManager.this.player, now);
                    break;
                }
                case ENERGY_NUM: {
                    int now = MathHelper.func_76125_a((int)(this.resources.get((Object)Resources.ENERGY_NUM) + num), (int)0, (int)this.resources.get((Object)Resources.MAX_ENERGY_NUM));
                    this.resources.put(Resources.ENERGY_NUM, now);
                    break;
                }
                default: {
                    int now = MathHelper.func_76125_a((int)(this.resources.get((Object)res) + num), (int)res.min, (int)res.max);
                    this.resources.put(res, now);
                    if (res != Resources.MONEY) break;
                    MoneyTrigger.INSTANCE.trigger((ServerPlayerEntity)PlayerDataManager.this.player, now);
                }
            }
            this.sendPacket(PlayerDataManager.this.player, res);
        }

        private void addTreeXp(int num) {
            int lvl = this.resources.get((Object)Resources.TREE_LVL);
            int now = this.resources.get((Object)Resources.TREE_XP);
            if (num > 0) {
                int req = PlayerUtil.getPlayerLevelUpXp(lvl);
                while (lvl < 100 && num + now >= req) {
                    num -= req - now;
                    this.addPlayerStats(Resources.TREE_LVL, 1);
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerLevelUpEvent.TreeLevelUpEvent(PlayerDataManager.this.player, ++lvl));
                    now = 0;
                    req = PlayerUtil.getPlayerLevelUpXp(lvl);
                }
                this.resources.put(Resources.TREE_XP, num + now);
            } else {
                for (num = -num; lvl > 1 && num > now; num -= now) {
                    now = PlayerUtil.getPlayerLevelUpXp(--lvl);
                    this.addPlayerStats(Resources.TREE_LVL, -1);
                }
                this.resources.put(Resources.TREE_XP, now - num);
            }
        }

        public void sendPacket(PlayerEntity player, Resources res) {
            if (player instanceof ServerPlayerEntity) {
                PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlayerStatsPacket(res.ordinal(), this.resources.get((Object)res)));
            }
        }

        private void saveToNBT(CompoundNBT baseTag) {
            CompoundNBT statsNBT = new CompoundNBT();
            for (Resources res : Resources.values()) {
                statsNBT.func_74768_a("player_" + res.toString(), this.resources.get((Object)res).intValue());
            }
            baseTag.func_218657_a("player_stats", (INBT)statsNBT);
        }

        private void loadFromNBT(CompoundNBT baseTag) {
            if (baseTag.func_74764_b("player_stats")) {
                CompoundNBT statsTag = baseTag.func_74775_l("player_stats");
                for (Resources res : Resources.values()) {
                    if (!statsTag.func_74764_b("player_" + res.toString())) continue;
                    this.resources.put(res, statsTag.func_74762_e("player_" + res.toString()));
                }
            }
        }
    }
}

