/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.command;

import com.hungteen.pvz.common.world.data.PVZInvasionData;
import com.hungteen.pvz.common.world.invasion.OverworldInvasion;
import com.hungteen.pvz.common.world.invasion.WaveManager;
import com.hungteen.pvz.utils.enums.InvasionEvents;
import com.hungteen.pvz.utils.enums.Zombies;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class InvasionCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"invasion").requires(ctx -> ctx.func_197034_c(2));
        for (InvasionEvents invasionEvents : InvasionEvents.values()) {
            builder.then(Commands.func_197057_a((String)"event").then(Commands.func_197057_a((String)"add").then(Commands.func_197057_a((String)invasionEvents.toString().toLowerCase()).executes(commond -> InvasionCommand.addInvasionEvent((CommandSource)commond.getSource(), event)))));
        }
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"event").then(Commands.func_197057_a((String)"clear").executes(commond -> InvasionCommand.clearInvasionEvent((CommandSource)commond.getSource())))).then(Commands.func_197057_a((String)"show").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(commond -> InvasionCommand.showInvasionEvent((CommandSource)commond.getSource(), EntityArgument.func_197090_e((CommandContext)commond, (String)"targets"))))));
        for (Enum enum_ : Zombies.values()) {
            builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"zombie").then(Commands.func_197057_a((String)"add").then(Commands.func_197057_a((String)enum_.toString().toLowerCase()).executes(arg_0 -> InvasionCommand.lambda$register$4((Zombies)enum_, arg_0))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197057_a((String)enum_.toString().toLowerCase()).executes(arg_0 -> InvasionCommand.lambda$register$5((Zombies)enum_, arg_0)))));
        }
        builder.then(Commands.func_197057_a((String)"wave").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(commond -> InvasionCommand.spawnHugeWave(EntityArgument.func_197090_e((CommandContext)commond, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)commond, (String)"amount"), 1))).then(Commands.func_197056_a((String)"wave_num", (ArgumentType)IntegerArgumentType.integer()).executes(commond -> InvasionCommand.spawnHugeWave(EntityArgument.func_197090_e((CommandContext)commond, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)commond, (String)"amount"), IntegerArgumentType.getInteger((CommandContext)commond, (String)"wave_num")))))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"difficulty").then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(commond -> InvasionCommand.addDifficulty((CommandSource)commond.getSource(), IntegerArgumentType.getInteger((CommandContext)commond, (String)"amount")))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(commond -> InvasionCommand.setDifficulty((CommandSource)commond.getSource(), IntegerArgumentType.getInteger((CommandContext)commond, (String)"amount")))))).then(Commands.func_197057_a((String)"query").executes(commond -> InvasionCommand.queryDifficulty((CommandSource)commond.getSource()))));
        dispatcher.register(builder);
    }

    private static int addDifficulty(CommandSource source, int amount) {
        PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData((World)source.func_197023_e());
        data.addCurrentDifficulty(amount);
        InvasionCommand.queryDifficulty(source);
        return 0;
    }

    private static int setDifficulty(CommandSource source, int amount) {
        PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData((World)source.func_197023_e());
        data.setCurrentDifficulty(amount);
        InvasionCommand.queryDifficulty(source);
        return 0;
    }

    private static int queryDifficulty(CommandSource source) {
        PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData((World)source.func_197023_e());
        source.func_197030_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("command.pvz.difficulty").getString() + " : " + data.getCurrentDifficulty()), true);
        return 0;
    }

    private static int addZombie(CommandSource source, Zombies zombie) {
        if (zombie.chooseWeight > 0) {
            OverworldInvasion.addZombie((World)source.func_197023_e(), zombie);
            source.func_197030_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("command.pvz.add_zombie").getString() + ":" + zombie.getText().getString()), true);
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("command.pvz.add_zombie_fail").getString()), false);
        }
        return 0;
    }

    private static int removeZombie(CommandSource source, Zombies zombie) {
        OverworldInvasion.removeZombie((World)source.func_197023_e(), zombie);
        source.func_197030_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("command.pvz.remove_zombie").getString() + ":" + zombie.getText().getString()), true);
        return 0;
    }

    private static int spawnHugeWave(Collection<? extends ServerPlayerEntity> targets, int num, int wave_num) {
        targets.forEach(player -> {
            WaveManager manager = new WaveManager((PlayerEntity)player, wave_num);
            if (num != 0) {
                manager.spawnCnt = num;
            }
            manager.spawnWaveZombies();
        });
        return targets.size();
    }

    public static int addInvasionEvent(CommandSource source, InvasionEvents event) {
        OverworldInvasion.activateEvent((World)source.func_197023_e(), event, true);
        source.func_197030_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("command.pvz.add_event").getString() + ":" + InvasionEvents.getEventText(event).getString()), true);
        return 0;
    }

    private static int clearInvasionEvent(CommandSource source) {
        OverworldInvasion.deactivateZombieAttackEvents((World)source.func_197023_e(), false);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.pvz.clear_events"), true);
        return 0;
    }

    private static int showInvasionEvent(CommandSource source, Collection<? extends ServerPlayerEntity> targets) {
        targets.forEach(player -> {
            PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData((World)source.func_197023_e());
            for (InvasionEvents event : InvasionEvents.values()) {
                if (!data.hasEvent(event)) continue;
                source.func_197030_a(InvasionEvents.getEventText(event), false);
            }
        });
        return targets.size();
    }

    private static /* synthetic */ int lambda$register$5(Zombies zombie, CommandContext commond) throws CommandSyntaxException {
        return InvasionCommand.removeZombie((CommandSource)commond.getSource(), zombie);
    }

    private static /* synthetic */ int lambda$register$4(Zombies zombie, CommandContext commond) throws CommandSyntaxException {
        return InvasionCommand.addZombie((CommandSource)commond.getSource(), zombie);
    }
}

