/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.command;

import com.hungteen.pvz.common.capability.CapabilityHandler;
import com.hungteen.pvz.utils.enums.Resources;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ResourceCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"playerstats").requires(ctx -> ctx.func_197034_c(2));
        for (Resources res : Resources.values()) {
            builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197057_a((String)"add").then(Commands.func_197057_a((String)res.toString().toLowerCase()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.addPlayerResource((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), res, IntegerArgumentType.getInteger((CommandContext)command, (String)"amount"))))))).then(Commands.func_197057_a((String)"query").then(Commands.func_197057_a((String)res.toString().toLowerCase()).executes(command -> ResourceCommand.queryPlayerResource((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), res))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197057_a((String)res.toString().toLowerCase()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.setPlayerResource((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), res, IntegerArgumentType.getInteger((CommandContext)command, (String)"amount")))))));
        }
        dispatcher.register(builder);
    }

    public static int addPlayerResource(CommandSource source, Collection<? extends ServerPlayerEntity> targets, Resources res, int num) {
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            serverPlayerEntity.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                l.getPlayerData().getPlayerStats().addPlayerStats(res, num);
                source.func_197030_a((ITextComponent)new StringTextComponent(res.getText().getString() + ":" + l.getPlayerData().getPlayerStats().getPlayerStats(res)), true);
            });
        }
        return targets.size();
    }

    public static int queryPlayerResource(CommandSource source, Collection<? extends ServerPlayerEntity> targets, Resources res) {
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            serverPlayerEntity.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> source.func_197030_a((ITextComponent)new StringTextComponent(res.getText().getString() + ":" + l.getPlayerData().getPlayerStats().getPlayerStats(res)), false));
        }
        return targets.size();
    }

    public static int setPlayerResource(CommandSource source, Collection<? extends ServerPlayerEntity> targets, Resources res, int num) {
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            serverPlayerEntity.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                l.getPlayerData().getPlayerStats().setPlayerStats(res, num);
                source.func_197030_a((ITextComponent)new StringTextComponent(res.getText().getString() + ":" + l.getPlayerData().getPlayerStats().getPlayerStats(res)), true);
            });
        }
        return targets.size();
    }
}

