/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.container.shop;

import com.hungteen.pvz.common.capability.CapabilityHandler;
import com.hungteen.pvz.common.container.shop.AbstractDaveShopContainer;
import com.hungteen.pvz.common.network.OtherStatsPacket;
import com.hungteen.pvz.common.network.PVZPacketHandler;
import com.hungteen.pvz.register.ContainerRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.TradeUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Ranks;
import com.hungteen.pvz.utils.enums.Resources;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MysteryShopContainer
extends AbstractDaveShopContainer {
    public static final int MAX_MYSTERY_GOOD = 8;

    public MysteryShopContainer(int id, PlayerEntity player) {
        super((ContainerType<? extends Container>)((ContainerType)ContainerRegister.MYSTERY_SHOP.get()), id, player);
        if (!player.field_70170_p.field_72995_K) {
            MysteryShopContainer.sendMysteryGoodsPacket(player, -1);
        }
    }

    public void buyGood(TradeUtil.DaveGoods good, int type) {
        if (good.toString().toLowerCase().startsWith("enjoy_card")) {
            int pos = good.toString().toLowerCase().charAt(good.toString().length() - 1) - 48;
            this.player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                l.getPlayerData().getOtherStats().mysteryGoods[pos] = -1;
                MysteryShopContainer.sendMysteryGoodsPacket(this.player, pos);
            });
            PlayerUtil.addPlayerStats(this.player, Resources.GEM_NUM, -TradeUtil.getGoodCost(good.setType(type)));
            this.output.func_70299_a(0, TradeUtil.getGoodItemStack(good.setType(type)));
        }
        this.player.field_70170_p.func_217384_a(null, (Entity)this.player, (SoundEvent)SoundRegister.DAVE_BUY.get(), SoundCategory.AMBIENT, 1.0f, 1.0f);
    }

    public static void genNextGoods(PlayerEntity player) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            ArrayList<Integer> array = new ArrayList<Integer>();
            int sum = 0;
            for (Plants plant : Plants.values()) {
                array.add(sum += Ranks.values().length - PlantUtil.getPlantRankByName(plant).ordinal() / 2 + 1);
            }
            block1: for (int i = 0; i < l.getPlayerData().getOtherStats().mysteryGoods.length; ++i) {
                int now = player.field_70170_p.field_73012_v.nextInt(sum);
                for (int j = 0; j < array.size(); ++j) {
                    if (now >= (Integer)array.get(j)) continue;
                    l.getPlayerData().getOtherStats().mysteryGoods[i] = j;
                    continue block1;
                }
            }
            l.getPlayerData().getOtherStats().updateGoodTick = 24000;
        });
    }

    public static void sendMysteryGoodsPacket(PlayerEntity player, int pos) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            if (pos == -1) {
                for (int i = 0; i < 8; ++i) {
                    PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OtherStatsPacket(0, i, l.getPlayerData().getOtherStats().mysteryGoods[i]));
                }
                PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OtherStatsPacket(0, -1, l.getPlayerData().getOtherStats().updateGoodTick));
            } else {
                PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OtherStatsPacket(0, pos, l.getPlayerData().getOtherStats().mysteryGoods[pos]));
            }
        });
    }
}

