/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity;

import com.hungteen.pvz.api.enums.PVZGroupType;
import com.hungteen.pvz.api.interfaces.IGroupEntity;
import com.hungteen.pvz.api.interfaces.IHasOwner;
import com.hungteen.pvz.common.entity.PVZEntityBase;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractOwnerEntity
extends PVZEntityBase
implements IGroupEntity,
IHasOwner {
    protected Entity owner;
    protected UUID ownerId;
    protected PVZGroupType groupType;

    public AbstractOwnerEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.groupType = this.getInitialEntityGroup();
    }

    public AbstractOwnerEntity(EntityType<?> type, World worldIn, Entity livingEntityIn) {
        super(type, worldIn);
        this.summonByOwner(livingEntityIn);
    }

    public void summonByOwner(Entity owner) {
        this.owner = owner;
        this.ownerId = owner.func_110124_au();
        this.groupType = EntityUtil.getEntityGroup(owner);
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setOwner(LivingEntity player) {
        this.owner = player;
    }

    @Nullable
    public Entity getOwner() {
        if (EntityUtil.isEntityValid(this.owner) && this.ownerId != null && this.field_70170_p instanceof ServerWorld) {
            this.owner = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerId);
        }
        return this.owner;
    }

    public Entity getOwnerOrSelf() {
        return this.getOwner() == null ? this : this.getOwner();
    }

    @Override
    public Optional<UUID> getOwnerUUID() {
        return Optional.ofNullable(this.field_96093_i);
    }

    public PVZGroupType getInitialEntityGroup() {
        return PVZGroupType.CREATURES;
    }

    @Override
    public PVZGroupType getEntityGroupType() {
        return this.groupType;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        if (this.ownerId != null) {
            compound.func_218657_a("owner", (INBT)NBTUtil.func_240626_a_((UUID)this.ownerId));
        }
        compound.func_74768_a("entity_tick_exist", this.field_70173_aa);
        compound.func_74768_a("group_owner_type", this.groupType.ordinal());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        this.owner = null;
        if (compound.func_150297_b("owner", 10)) {
            this.ownerId = NBTUtil.func_186860_b((INBT)compound.func_74775_l("owner"));
        }
        if (compound.func_74764_b("entity_tick_exist")) {
            this.field_70173_aa = compound.func_74762_e("entity_tick_exist");
        }
        if (compound.func_74764_b("group_owner_type")) {
            this.groupType = PVZGroupType.getGroup(compound.func_74762_e("group_owner_type"));
        }
    }
}

