/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.ai.goal.target;

import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class PVZTargetGoal
extends Goal {
    protected final MobEntity mob;
    protected LivingEntity targetMob;
    protected final boolean mustSee;
    protected final boolean mustReach;
    protected int targetChance = 5;
    private final float upperHeight;
    private final float lowerHeight;
    private final float width;

    public PVZTargetGoal(MobEntity mobIn, boolean mustSee, boolean mustReach, float w, float h) {
        this(mobIn, mustSee, mustReach, w, h, h);
    }

    public PVZTargetGoal(MobEntity mobIn, boolean mustSee, boolean mustReach, float w, float h1, float h2) {
        this.mob = mobIn;
        this.mustSee = mustSee;
        this.mustReach = mustReach;
        this.width = w;
        this.upperHeight = h1;
        this.lowerHeight = h2;
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public void func_75249_e() {
        this.mob.func_70624_b(this.targetMob);
    }

    public boolean func_75253_b() {
        LivingEntity entity = this.mob.func_70638_az();
        if (!EntityUtil.isEntityValid((Entity)entity)) {
            entity = this.targetMob;
        }
        if (!EntityUtil.isEntityValid((Entity)entity)) {
            return false;
        }
        if (Math.abs(entity.func_226277_ct_() - this.mob.func_226277_ct_()) > (double)this.width || Math.abs(entity.func_226281_cx_() - this.mob.func_226281_cx_()) > (double)this.width) {
            return false;
        }
        if (EntityUtil.canAttackEntity((Entity)this.mob, (Entity)entity) && (this.mustReach || !this.mustSee || this.checkSenses((Entity)entity)) && this.checkOther(entity)) {
            this.mob.func_70624_b(entity);
            return true;
        }
        return false;
    }

    public void func_75251_c() {
        this.mob.func_70624_b(null);
    }

    protected boolean checkSenses(Entity entity) {
        return this.mob.func_70635_at().func_75522_a(entity);
    }

    protected boolean checkOther(LivingEntity entity) {
        return !this.mustSee || !entity.func_82150_aj() || !(this.mob.func_70068_e((Entity)entity) > 100.0) || this.mob.func_70644_a((Effect)EffectRegister.LIGHT_EYE_EFFECT.get()) && this.mob.func_70660_b((Effect)EffectRegister.LIGHT_EYE_EFFECT.get()).func_76458_c() != 0;
    }

    protected AxisAlignedBB getAABB() {
        return new AxisAlignedBB(this.mob.func_226277_ct_() + (double)this.width, this.mob.func_226278_cu_() + (double)this.upperHeight, this.mob.func_226281_cx_() + (double)this.width, this.mob.func_226277_ct_() - (double)this.width, this.mob.func_226278_cu_() - (double)this.lowerHeight, this.mob.func_226281_cx_() - (double)this.width);
    }
}

