/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.bullet;

import com.hungteen.pvz.common.entity.bullet.PultBulletEntity;
import com.hungteen.pvz.common.entity.plant.ice.WinterMelonEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class MelonEntity
extends PultBulletEntity {
    private static final DataParameter<Integer> MELON_STATE = EntityDataManager.func_187226_a(MelonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Entity attackEntity = null;

    public MelonEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public MelonEntity(World worldIn, LivingEntity shooter) {
        super((EntityType)EntityRegister.MELON.get(), worldIn, shooter);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MELON_STATE, (Object)MelonStates.NORMAL.ordinal());
    }

    @Override
    protected void dealDamage(Entity target) {
        if (this.getMelonState() == MelonStates.ICE) {
            PVZDamageSource source = PVZDamageSource.winterMelon(this, (Entity)this.getThrower());
            this.getColdEffect().ifPresent(e -> source.addEffect((EffectInstance)e));
            target.func_70097_a((DamageSource)source, this.getAttackDamage());
        } else {
            target.func_70097_a((DamageSource)PVZDamageSource.melon(this, (Entity)this.getThrower()), this.getAttackDamage());
        }
        this.attackEntity = target;
        this.dealSplashDamage();
    }

    @Override
    protected void onHitBlock() {
        this.dealSplashDamage();
    }

    public void dealSplashDamage() {
        float range = 3.0f;
        EntityUtil.getTargetableEntities(this.getOwnerOrSelf(), EntityUtil.getEntityAABB(this, 3.0, 3.0)).forEach(entity -> {
            if (!entity.func_70028_i(this.attackEntity) && this.shouldHit((Entity)entity)) {
                if (this.getMelonState() == MelonStates.ICE) {
                    PVZDamageSource source = PVZDamageSource.winterMelon(this, (Entity)this.getThrower());
                    this.getColdEffect().ifPresent(e -> source.addEffect((EffectInstance)e));
                    entity.func_70097_a((DamageSource)source, this.getAttackDamage() / 2.0f);
                } else {
                    PVZDamageSource source = PVZDamageSource.melon(this, (Entity)this.getThrower());
                    entity.func_70097_a((DamageSource)source, this.getAttackDamage() / 2.0f);
                }
            }
        });
        for (int i = 0; i < 10; ++i) {
            EntityUtil.spawnParticle(this, this.getMelonState() == MelonStates.ICE ? 2 : 1);
        }
        EntityUtil.playSound(this, (SoundEvent)SoundRegister.MELON_HIT.get());
    }

    protected Optional<EffectInstance> getColdEffect() {
        if (this.getThrower() instanceof WinterMelonEntity) {
            return ((WinterMelonEntity)this.getThrower()).getColdEffect();
        }
        return Optional.empty();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.6f, (float)0.6f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("melon_state")) {
            this.setMelonState(MelonStates.values()[compound.func_74762_e("melon_state")]);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("melon_state", this.getMelonState().ordinal());
    }

    public void setMelonState(MelonStates type) {
        this.field_70180_af.func_187227_b(MELON_STATE, (Object)type.ordinal());
    }

    public MelonStates getMelonState() {
        return MelonStates.values()[(Integer)this.field_70180_af.func_187225_a(MELON_STATE)];
    }

    public static enum MelonStates {
        NORMAL,
        ICE;

    }
}

