/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.bullet;

import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StarEntity
extends AbstractBulletEntity {
    private static final DataParameter<Integer> STAR_TYPE = EntityDataManager.func_187226_a(StarEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STAR_STATE = EntityDataManager.func_187226_a(StarEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public StarEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public StarEntity(World worldIn, LivingEntity livingEntityIn, StarTypes starType, StarStates starState) {
        super((EntityType)EntityRegister.STAR.get(), worldIn, livingEntityIn);
        this.setStarType(starType);
        this.setStarState(starState);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STAR_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(STAR_STATE, (Object)0);
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        Entity target;
        boolean flag = false;
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && this.shouldHit(target = ((EntityRayTraceResult)result).func_216348_a())) {
            target.field_70172_ad = 0;
            this.dealStarDamage(target);
            flag = true;
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        if (flag || !this.checkLive(result)) {
            this.func_70106_y();
        }
    }

    private void dealStarDamage(Entity target) {
        target.func_70097_a((DamageSource)PVZDamageSource.star(this, (Entity)this.getThrower()), this.getAttackDamage());
    }

    @Override
    protected int getMaxLiveTick() {
        return 30;
    }

    @Override
    public float getAttackDamage() {
        float damage = this.attackDamage;
        if (this.getStarType() == StarTypes.BIG) {
            damage += 5.0f;
        }
        if (this.getStarType() == StarTypes.HUGE) {
            damage += 10.0f;
        }
        return damage;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.getStarType() == StarTypes.BIG) {
            return EntitySize.func_220314_b((float)0.5f, (float)0.2f);
        }
        if (this.getStarType() == StarTypes.HUGE) {
            return EntitySize.func_220314_b((float)0.8f, (float)0.2f);
        }
        return EntitySize.func_220314_b((float)0.2f, (float)0.2f);
    }

    @Override
    protected float getGravityVelocity() {
        return 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.field_70177_z += 10.0f;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("star_state")) {
            this.setStarState(StarStates.values()[compound.func_74762_e("star_state")]);
        }
        if (compound.func_74764_b("star_type")) {
            this.setStarType(StarTypes.values()[compound.func_74762_e("star_type")]);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("star_state", this.getStarState().ordinal());
        compound.func_74768_a("star_type", this.getStarType().ordinal());
    }

    public StarStates getStarState() {
        return StarStates.values()[(Integer)this.field_70180_af.func_187225_a(STAR_STATE)];
    }

    public void setStarState(StarStates state) {
        this.field_70180_af.func_187227_b(STAR_STATE, (Object)state.ordinal());
    }

    public StarTypes getStarType() {
        return StarTypes.values()[(Integer)this.field_70180_af.func_187225_a(STAR_TYPE)];
    }

    public void setStarType(StarTypes type) {
        this.field_70180_af.func_187227_b(STAR_TYPE, (Object)type.ordinal());
    }

    public static enum StarTypes {
        NORMAL,
        BIG,
        HUGE;

    }

    public static enum StarStates {
        YELLOW,
        PINK;

    }
}

