/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.bullet;

import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.plant.spear.CatTailEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ThornEntity
extends AbstractBulletEntity {
    private static final DataParameter<Integer> THORN_TYPE = EntityDataManager.func_187226_a(ThornEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THORN_STATE = EntityDataManager.func_187226_a(ThornEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private IntOpenHashSet set = new IntOpenHashSet();
    private LivingEntity thornTarget;
    private int extraHitCount = 0;

    public ThornEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public ThornEntity(World worldIn, LivingEntity shooter) {
        super((EntityType)EntityRegister.THORN.get(), worldIn, shooter);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(THORN_TYPE, (Object)ThornTypes.NORMAL.ordinal());
        this.field_70180_af.func_187214_a(THORN_STATE, (Object)ThornStates.NORMAL.ordinal());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70145_X = true;
        if (!this.field_70170_p.field_72995_K) {
            Vector3d vec = this.getShootVec().func_72432_b();
            if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
                float f = MathHelper.func_76133_a((double)ThornEntity.func_213296_b((Vector3d)vec));
                this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec.field_72450_a, (double)vec.field_72449_c) * 57.2957763671875);
                this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec.field_72448_b, (double)f) * 57.2957763671875);
                this.field_70126_B = this.field_70177_z;
                this.field_70127_C = this.field_70125_A;
            }
            if ((this.getThornType() == ThornTypes.GUIDE || this.getThornType() == ThornTypes.AUTO) && vec != Vector3d.field_186680_a) {
                this.func_213317_d(vec.func_186678_a(this.getBulletSpeed()));
            }
            if (this.getThornType() == ThornTypes.AUTO && !EntityUtil.isEntityValid((Entity)this.thornTarget) && this.field_70173_aa % 20 == 0) {
                this.thornTarget = this.getRandomAttackTarget();
            }
            if (EntityUtil.isEntityValid((Entity)this.thornTarget) && this.func_70068_e((Entity)this.thornTarget) <= 4.0) {
                this.onImpact((Entity)this.thornTarget);
            }
            if (this.getThrower() == null) {
                this.func_70106_y();
            }
        }
    }

    public LivingEntity getRandomAttackTarget() {
        float range = 40.0f;
        List list = this.field_70170_p.func_175647_a(LivingEntity.class, EntityUtil.getEntityAABB(this, 40.0, 40.0), entity -> !entity.func_70028_i((Entity)this.thornTarget) && EntityUtil.canTargetEntity(this.getOwnerOrSelf(), (Entity)entity));
        if (list.size() == 0) {
            return null;
        }
        return (LivingEntity)list.get(this.field_70146_Z.nextInt(list.size()));
    }

    public Vector3d getShootVec() {
        if (this.thornTarget == null) {
            return Vector3d.field_186680_a;
        }
        return this.thornTarget.func_213303_ch().func_72441_c(0.0, (double)this.thornTarget.func_70047_e(), 0.0).func_178788_d(this.func_213303_ch());
    }

    public void setThornTarget(LivingEntity target) {
        this.thornTarget = target;
    }

    public void setExtraHitCount(int cnt) {
        this.extraHitCount = cnt;
    }

    public double getBulletSpeed() {
        if (this.getThrower() instanceof CatTailEntity) {
            return this.getThornType() == ThornTypes.AUTO ? 0.85 : 0.55;
        }
        return 0.15;
    }

    public boolean isInControl() {
        return this.getThornType() == ThornTypes.GUIDE;
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity target = ((EntityRayTraceResult)result).func_216348_a();
            this.onImpact(target);
        }
    }

    private void onImpact(Entity target) {
        if (this.shouldHit(target)) {
            target.field_70172_ad = 0;
            this.dealThornDamage(target);
            if (this.getThornType() == ThornTypes.GUIDE) {
                this.setThornType(ThornTypes.NORMAL);
                this.set.add(target.func_145782_y());
            } else if (this.getThornType() == ThornTypes.AUTO) {
                this.thornTarget = this.getRandomAttackTarget();
            } else {
                this.set.add(target.func_145782_y());
                --this.extraHitCount;
            }
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        if (this.getThornType() != ThornTypes.AUTO && this.extraHitCount == 0) {
            this.func_70106_y();
        }
    }

    protected void dealThornDamage(Entity target) {
        target.func_70097_a((DamageSource)PVZDamageSource.causeThornDamage(this, this), this.getAttackDamage());
    }

    @Override
    public float getAttackDamage() {
        float damage = this.attackDamage;
        if (this.getThornType() == ThornTypes.AUTO) {
            damage += 10.0f;
        }
        return damage;
    }

    @Override
    protected boolean checkLive(RayTraceResult result) {
        return true;
    }

    @Override
    protected boolean shouldHit(Entity target) {
        if (!super.shouldHit(target)) {
            return false;
        }
        if (this.getThornType() == ThornTypes.AUTO) {
            return target.equals((Object)this.thornTarget);
        }
        return !this.set.contains(target.func_145782_y());
    }

    @Override
    protected int getMaxLiveTick() {
        return this.getThornType() == ThornTypes.AUTO ? 500 : (this.isInControl() ? 250 : 150);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.2f, (float)0.2f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("thorn_state", this.getThornState().ordinal());
        compound.func_74768_a("thorn_type", this.getThornType().ordinal());
        compound.func_74768_a("extra_hit_count", this.extraHitCount);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.getThrower() != null && this.getThrower() instanceof CatTailEntity && this.isInControl()) {
            ((CatTailEntity)this.getThrower()).thorns.add(this);
        }
        if (compound.func_74764_b("thorn_state")) {
            this.setThornState(ThornStates.values()[compound.func_74762_e("thorn_state")]);
        }
        if (compound.func_74764_b("thorn_type")) {
            this.setThornType(ThornTypes.values()[compound.func_74762_e("thorn_type")]);
        }
        if (compound.func_74764_b("extra_hit_count")) {
            this.extraHitCount = compound.func_74762_e("extra_hit_count");
        }
    }

    public ThornStates getThornState() {
        return ThornStates.values()[(Integer)this.field_70180_af.func_187225_a(THORN_STATE)];
    }

    public void setThornState(ThornStates state) {
        this.field_70180_af.func_187227_b(THORN_STATE, (Object)state.ordinal());
    }

    public ThornTypes getThornType() {
        return ThornTypes.values()[(Integer)this.field_70180_af.func_187225_a(THORN_TYPE)];
    }

    public void setThornType(ThornTypes type) {
        this.field_70180_af.func_187227_b(THORN_TYPE, (Object)type.ordinal());
    }

    public static enum ThornTypes {
        NORMAL,
        GUIDE,
        AUTO;

    }

    public static enum ThornStates {
        NORMAL,
        POWER;

    }
}

