/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.drop;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.common.enchantment.EnchantmentUtil;
import com.hungteen.pvz.common.entity.drop.DropEntity;
import com.hungteen.pvz.common.event.events.PlayerCollectDropEvent;
import com.hungteen.pvz.common.network.PVZPacketHandler;
import com.hungteen.pvz.common.network.PlaySoundPacket;
import com.hungteen.pvz.register.EnchantmentRegister;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Resources;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;

public class SunEntity
extends DropEntity {
    private float fall_speed = 0.03f;

    public SunEntity(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.setAmount(25);
        this.func_189654_d(true);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70122_E && !this.func_70090_H()) {
            this.func_213293_j(this.func_213322_ci().func_82615_a(), -this.fall_speed, this.func_213322_ci().func_82616_c());
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        int amount = this.getAmount();
        float w = (float)amount * 1.0f / 200.0f + 0.3f;
        float h = (float)amount * 1.0f / 75.0f + 0.1f;
        return new EntitySize(w, h, false);
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.getDropState() != DropEntity.DropStates.STEAL) {
            this.onCollectedByPlayer(entityIn);
        }
    }

    public void onCollectedByPlayer(PlayerEntity player) {
        ItemStack stack;
        if (MinecraftForge.EVENT_BUS.post((Event)new PlayerCollectDropEvent.PlayerCollectSunEvent(player, this))) {
            return;
        }
        Map.Entry entry = EnchantmentHelper.func_222189_b((Enchantment)((Enchantment)EnchantmentRegister.SUN_MENDING.get()), (LivingEntity)player);
        if (entry != null && !(stack = (ItemStack)entry.getValue()).func_190926_b() && stack.func_77951_h()) {
            int canRepair = Math.min(EnchantmentUtil.getRepairDamageByAmount(stack, this.getAmount()), stack.func_77952_i());
            this.setAmount(this.getAmount() - EnchantmentUtil.getSunCostByDamage(stack, canRepair));
            stack.func_196085_b(stack.func_77952_i() - canRepair);
        }
        if (this.getAmount() > 0) {
            PlayerUtil.addPlayerStats(player, Resources.SUN_NUM, this.getAmount());
        }
        PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlaySoundPacket(0));
        this.func_70106_y();
    }

    public int func_70641_bl() {
        return 1;
    }

    public static void spawnSunsByAmount(World world, BlockPos pos, int amount) {
        SunEntity.spawnSunsByAmount(world, pos, amount, 75, 1);
    }

    public static void spawnSunsByAmount(World world, BlockPos pos, int amount, int each, int range) {
        while (amount >= each) {
            amount -= each;
            SunEntity.spawnSunRandomly(world, pos, each, range);
        }
        if (amount != 0) {
            SunEntity.spawnSunRandomly(world, pos, amount, range);
            amount = 0;
        }
    }

    public static void spawnSunRandomly(World world, BlockPos pos, int amount, int dis) {
        SunEntity sun = (SunEntity)((EntityType)EntityRegister.SUN.get()).func_200721_a(world);
        sun.setAmount(amount);
        EntityUtil.onMobEntityRandomPosSpawn((IWorld)world, sun, pos, dis);
    }

    public static boolean canSunSpawn(EntityType<? extends SunEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        if (worldIn instanceof ServerWorld) {
            return !((ServerWorld)worldIn).func_175727_C(pos) && ((ServerWorld)worldIn).func_72935_r() && worldIn.func_226658_a_(LightType.SKY, pos) >= 15;
        }
        return worldIn.func_226658_a_(LightType.SKY, pos) >= 15;
    }

    @Override
    protected int getMaxLiveTick() {
        return (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.EntityLiveTick.SunLiveTick.get();
    }
}

