/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.misc;

import com.hungteen.pvz.register.ItemRegister;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class BobsleCarEntity
extends Entity {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(BobsleCarEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(BobsleCarEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final int MAX_PASSENGER_SIZE = 4;
    private static final float SNOW_SMOOTH = 0.991f;
    private static final float MAX_MOVE_SPEED = 0.042f;
    private static final float MAX_ROTATION = 1.0f;
    private Status status;
    private float momentum;
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private float boatGlide;

    public BobsleCarEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_213323_x_();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.status = this.getCarStatus();
        if (this.status == Status.IN_WATER) {
            this.func_184226_ay();
            this.func_70106_y();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.tickLerp();
        if (this.func_184186_bw()) {
            this.updateMotion();
            if (this.field_70170_p.field_72995_K) {
                this.updateControls();
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.func_145775_I();
        if (!this.field_70170_p.field_72995_K) {
            for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this))) {
                if (entity.func_184218_aH()) continue;
                if (this.checkCanRideOn(entity)) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    private boolean checkCanRideOn(Entity entity) {
        return !(this.func_184179_bs() instanceof PlayerEntity) && this.func_184188_bt().size() < 4 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec3d, Hand hand) {
        if (player.func_226563_dT_()) {
            return ActionResultType.FAIL;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void updateControls() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((PlayerEntity)mc.field_71439_g)) {
            float f = 0.0f;
            boolean left = mc.field_71474_y.field_74370_x.func_151470_d();
            boolean right = mc.field_71474_y.field_74366_z.func_151470_d();
            boolean forward = mc.field_71474_y.field_74351_w.func_151470_d();
            boolean back = mc.field_71474_y.field_74368_y.func_151470_d();
            if (left) {
                this.deltaRotation -= 1.0f;
            }
            if (right) {
                this.deltaRotation += 1.0f;
            }
            if (!right && !left) {
                this.deltaRotation = 0.0f;
            }
            this.field_70177_z += this.deltaRotation;
            if (right != left && !forward && !back) {
                f += 0.0042f;
            }
            if (forward) {
                f += 0.042f;
            }
            if (back) {
                f -= 0.0139999995f;
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isRidingPlayer(PlayerEntity player) {
        return player.func_184187_bx() != null && player.func_184187_bx() == this;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_70104_M() {
        return true;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 4;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    public boolean func_205710_ba() {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public double func_70042_X() {
        return 0.2;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199703_a((IItemProvider)ItemRegister.BOBSLE_CAR.get());
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    private Status getCarStatus() {
        if (this.func_70090_H()) {
            return Status.IN_WATER;
        }
        float f = this.getCarGlide();
        if (f == 0.991f) {
            this.boatGlide = f;
            return Status.ON_SNOW;
        }
        if (f > 0.0f) {
            this.boatGlide = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getCarGlide() {
        if (this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c() == Blocks.field_150433_aE || this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_177230_c() == Blocks.field_196604_cC) {
            return 0.991f;
        }
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.func_181079_c(l1, k2, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
                    if (blockstate.func_177230_c() instanceof LilyPadBlock || !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196952_d((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable).func_197751_a((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                    f += blockstate.getSlipperiness((IWorldReader)this.field_70170_p, (BlockPos)blockpos$mutable, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private void updateMotion() {
        double d1 = -0.04;
        this.momentum = 0.05f;
        if (this.status == Status.IN_AIR) {
            this.momentum = 0.9f;
        } else if (this.status == Status.ON_LAND) {
            this.momentum = this.boatGlide;
            if (this.func_184179_bs() instanceof PlayerEntity) {
                this.boatGlide /= 2.0f;
            }
        } else if (this.status == Status.ON_SNOW) {
            this.momentum = this.boatGlide;
            if (this.func_184179_bs() instanceof PlayerEntity) {
                this.boatGlide /= 2.0f;
            }
        }
        Vector3d vec3d = this.func_213322_ci();
        this.func_213293_j(vec3d.field_72450_a * (double)this.momentum, vec3d.field_72448_b + d1, vec3d.field_72449_c * (double)this.momentum);
        this.deltaRotation *= this.momentum;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = 0.2f - 0.7f * (float)i;
                if (passenger instanceof AnimalEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vector3d vec3d = new Vector3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vec3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.applyYawToEntity(passenger);
            if (passenger instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.status != Status.ON_LAND && this.status != Status.ON_SNOW) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.func_199703_a((IItemProvider)ItemRegister.BOBSLE_CAR.get());
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.func_70080_a(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.25f, (float)1.4f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Status {
        IN_WATER,
        ON_SNOW,
        ON_LAND,
        IN_AIR;

    }
}

