/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.misc;

import com.hungteen.pvz.common.entity.AbstractOwnerEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.zombie.roof.ZomBossEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class DestroyCarEntity
extends AbstractOwnerEntity {
    protected final float height = 20.0f;

    public DestroyCarEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public DestroyCarEntity(World worldIn, ZomBossEntity boss) {
        super((EntityType)EntityRegister.DESTROY_CAR.get(), worldIn, (Entity)boss);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa >= 100) {
            this.func_70106_y();
        }
        this.tickMove();
        this.tickCollision();
    }

    public void shootPultBullet(LivingEntity target) {
        if (target == null) {
            System.out.println("Warn: No target at all .");
            return;
        }
        double g = this.getGravityVelocity();
        double t1 = MathHelper.func_76133_a((double)(40.0 / g));
        double t2 = 0.0;
        if (this.func_226278_cu_() + 20.0 - target.func_226278_cu_() - (double)target.func_213302_cg() >= 0.0) {
            t2 = MathHelper.func_76133_a((double)(2.0 * (this.func_226278_cu_() + 20.0 - target.func_226278_cu_() - (double)target.func_213302_cg()) / g));
        }
        double dx = target.func_226277_ct_() + target.func_213322_ci().func_82615_a() * (t1 + t2) - this.func_226277_ct_();
        double dz = target.func_226281_cx_() + target.func_213322_ci().func_82616_c() * (t1 + t2) - this.func_226281_cx_();
        double dxz = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double vxz = dxz / (t1 + t2);
        double vy = g * t1;
        this.func_213293_j(vxz * dx / dxz, vy + (double)(MathUtil.getRandomFloat(this.field_70146_Z) / 10.0f), vxz * dz / dxz);
    }

    private void tickCollision() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0) {
            EntityUtil.getTargetableEntities(this.getOwnerOrSelf(), this.func_174813_aQ().func_186662_g(1.0)).forEach(target -> {
                if (target instanceof PVZPlantEntity) {
                    target.func_70097_a((DamageSource)PVZDamageSource.causeDeadlyDamage(this, this.getOwner()), EntityUtil.getCurrentMaxHealth((LivingEntity)((PVZPlantEntity)target)) * 2.0f);
                } else {
                    target.func_70097_a((DamageSource)PVZDamageSource.normal(this, this.getOwner()), 5.0f);
                }
            });
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)2.0f, (float)2.0f);
    }
}

