/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.misc;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.common.entity.AbstractOwnerEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.flame.JalapenoEntity;
import com.hungteen.pvz.common.entity.plant.ice.IceShroomEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.item.card.PlantCardItem;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ElementBallEntity
extends AbstractOwnerEntity {
    private static final DataParameter<Integer> ELEMENTS = EntityDataManager.func_187226_a(ElementBallEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected Optional<Entity> target = Optional.empty();
    public float speed = 0.25f;
    private final int SEARACH_CD = 20;
    private final float SEARCH_RANGE = 50.0f;

    public ElementBallEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ELEMENTS, (Object)ElementTypes.FLAME.ordinal());
    }

    public static void killElementBalls(LivingEntity attacker, float range, ElementTypes type) {
        attacker.field_70170_p.func_175647_a(ElementBallEntity.class, EntityUtil.getEntityAABB((Entity)attacker, range, range), target -> target.getElementBallType() == type && EntityUtil.checkCanEntityBeAttack((Entity)attacker, target)).forEach(target -> target.onKilledByPlants(attacker));
    }

    public void onKilledByPlants(LivingEntity entity) {
        if (entity instanceof PVZPlantEntity) {
            PVZPlantEntity plant = (PVZPlantEntity)entity;
            plant.getOwnerUUID().ifPresent(uuid -> {
                PlayerEntity player = this.field_70170_p.func_217371_b(uuid);
                if (player != null) {
                    PlantCardItem item = this.getElementBallType() == ElementTypes.FLAME ? (PlantCardItem)ItemRegister.ICE_SHROOM_CARD.get() : (PlantCardItem)ItemRegister.JALAPENO_CARD.get();
                    float percent = player.func_184811_cZ().func_185143_a((Item)item, 0.0f);
                    player.func_184811_cZ().func_185145_a((Item)item, MathHelper.func_76141_d((float)(200.0f * percent)));
                }
            });
        }
        this.func_70106_y();
    }

    @Override
    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.tickMove();
        this.tickCollision();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa >= (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.EntityLiveTick.ElementBallLiveTick.get()) {
                this.func_70106_y();
                return;
            }
            if (this.target.isPresent()) {
                if (!EntityUtil.isEntityValid(this.target.get())) {
                    this.target = Optional.empty();
                    return;
                }
                this.func_213317_d(this.target.get().func_213303_ch().func_178788_d(this.func_213303_ch()).func_72432_b().func_186678_a((double)this.speed));
            } else if (this.field_70146_Z.nextInt(this.SEARACH_CD) == 0) {
                this.getClass();
                this.getClass();
                List<LivingEntity> list = EntityUtil.getTargetableLivings(this, EntityUtil.getEntityAABB(this, 50.0, 50.0));
                if (list.isEmpty()) {
                    return;
                }
                this.target = Optional.ofNullable(list.get(this.field_70146_Z.nextInt(list.size())));
            }
        }
    }

    private void tickCollision() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0) {
            EntityUtil.getTargetableEntities(this, this.func_174813_aQ().func_186662_g(1.0)).forEach(target -> {
                if (target instanceof PVZPlantEntity) {
                    if (!(target instanceof JalapenoEntity && this.getElementBallType() == ElementTypes.ICE || target instanceof IceShroomEntity && this.getElementBallType() == ElementTypes.FLAME)) {
                        target.func_70097_a((DamageSource)this.getAttackSource(), EntityUtil.getCurrentMaxHealth((LivingEntity)((PVZPlantEntity)target)));
                    }
                } else if (target instanceof PVZZombieEntity) {
                    target.func_70097_a((DamageSource)this.getAttackSource(), EntityUtil.getCurrentMaxHealth((LivingEntity)((PVZZombieEntity)target)));
                } else {
                    target.func_70097_a((DamageSource)this.getAttackSource(), 5.0f);
                    target.func_213317_d(target.func_213303_ch().func_178788_d(this.func_213303_ch()).func_72432_b().func_186678_a((double)this.speed));
                }
            });
        }
    }

    private PVZDamageSource getAttackSource() {
        if (this.getElementBallType() == ElementTypes.FLAME) {
            return PVZDamageSource.causeFlameDamage(this, this.getOwner());
        }
        return PVZDamageSource.causeIceDamage(this, this.getOwner());
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)3.0f, (float)3.0f);
    }

    public boolean func_189652_ae() {
        return true;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("element_ball_type")) {
            this.setElementBallType(ElementTypes.values()[compound.func_74762_e("element_ball_type")]);
        }
        if (compound.func_74764_b("element_target")) {
            this.target = Optional.ofNullable(this.field_70170_p.func_73045_a(compound.func_74762_e("element_target")));
        }
        if (compound.func_74764_b("element_speed")) {
            this.speed = compound.func_74760_g("element_speed");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("element_ball_type", this.getElementBallType().ordinal());
        if (this.target.isPresent()) {
            compound.func_74768_a("element_target", this.target.get().func_145782_y());
        }
        compound.func_74776_a("element_speed", this.speed);
    }

    public void setElementBallType(ElementTypes type) {
        this.field_70180_af.func_187227_b(ELEMENTS, (Object)type.ordinal());
    }

    public ElementTypes getElementBallType() {
        return ElementTypes.values()[(Integer)this.field_70180_af.func_187225_a(ELEMENTS)];
    }

    public static enum ElementTypes {
        FLAME,
        ICE;

    }
}

