/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.misc;

import com.hungteen.pvz.common.entity.AbstractOwnerEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class FireCrackersEntity
extends AbstractOwnerEntity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(FireCrackersEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public FireCrackersEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public FireCrackersEntity(World worldIn, LivingEntity living) {
        super((EntityType)EntityRegister.FIRE_CRACKERS.get(), worldIn, (Entity)living);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, (Object)80);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.getFuse() > 0) {
            this.setFuse(this.getFuse() - 1);
            if (this.getFuse() <= 0) {
                this.explode();
                this.func_70106_y();
            }
        }
        this.tickMove();
    }

    protected void explode() {
        float range = 2.0f;
        EntityUtil.playSound(this, SoundEvents.field_187539_bB);
        EntityUtil.getTargetableEntities(this, EntityUtil.getEntityAABB(this, 2.0, 2.0)).forEach(target -> {
            target.func_70097_a((DamageSource)PVZDamageSource.explode(this, this.getOwner()), 50.0f);
            target.func_213317_d(target.func_213322_ci().func_72441_c(0.0, 2.0, 0.0));
        });
        for (int i = 0; i < 2; ++i) {
            EntityUtil.spawnParticle(this, 5);
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("fuse_tick")) {
            this.setFuse(compound.func_74762_e("fuse_tick"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("fuse_tick", this.getFuse());
    }

    public void setFuse(int tick) {
        this.field_70180_af.func_187227_b(FUSE, (Object)tick);
    }

    public int getFuse() {
        return (Integer)this.field_70180_af.func_187225_a(FUSE);
    }
}

