/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.misc;

import com.hungteen.pvz.api.enums.PVZGroupType;
import com.hungteen.pvz.common.entity.AbstractOwnerEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ZombieHandEntity
extends AbstractOwnerEntity {
    private int lifeTick;
    private final int maxLifeTick = 40;

    public ZombieHandEntity(EntityType<? extends Entity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_184224_h(true);
        this.field_70145_X = true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lifeTick < 40) {
            ++this.lifeTick;
        } else if (!this.field_70170_p.field_72995_K) {
            this.performAttack();
            this.func_70106_y();
        }
    }

    public static void spawnRangeZombieHands(World world, PVZZombieEntity zombie, int range) {
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                ZombieHandEntity hand = (ZombieHandEntity)((EntityType)EntityRegister.ZOMBIE_HAND.get()).func_200721_a(world);
                hand.summonByOwner((Entity)zombie);
                EntityUtil.onEntitySpawn((IWorld)world, hand, WorldUtil.getSuitableHeightPos(world, zombie.func_233580_cy_().func_177982_a(i, 0, j)));
            }
        }
    }

    protected void performAttack() {
        EntityUtil.getTargetableLivings(this, EntityUtil.getEntityAABB(this, 0.5, 1.0)).forEach(target -> {
            target.func_70097_a((DamageSource)PVZDamageSource.normal(this, this.getOwnerOrSelf()), this.getAttackDamage((LivingEntity)target));
            target.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_() - 3.0, target.func_226281_cx_());
        });
    }

    @Override
    public PVZGroupType getInitialEntityGroup() {
        return PVZGroupType.ZOMBIES;
    }

    private float getAttackDamage(LivingEntity target) {
        return 10.0f;
    }

    public int getTick() {
        return this.lifeTick;
    }

    public boolean func_70067_L() {
        return false;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.4f, 0.5f, false);
    }

    public boolean func_189652_ae() {
        return true;
    }
}

