/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant;

import com.hungteen.pvz.api.enums.PVZGroupType;
import com.hungteen.pvz.api.interfaces.IPVZPlant;
import com.hungteen.pvz.common.advancement.trigger.PlantSuperTrigger;
import com.hungteen.pvz.common.capability.CapabilityHandler;
import com.hungteen.pvz.common.entity.ai.goal.PVZLookRandomlyGoal;
import com.hungteen.pvz.common.entity.drop.SunEntity;
import com.hungteen.pvz.common.entity.plant.enforce.SquashEntity;
import com.hungteen.pvz.common.entity.plant.light.GoldLeafEntity;
import com.hungteen.pvz.common.entity.plant.spear.SpikeWeedEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.grassnight.TombStoneEntity;
import com.hungteen.pvz.common.entity.zombie.roof.BungeeZombieEntity;
import com.hungteen.pvz.common.item.card.ImitaterCardItem;
import com.hungteen.pvz.common.item.card.PlantCardItem;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.AlgorithmUtil;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Essences;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Ranks;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class PVZPlantEntity
extends CreatureEntity
implements IPVZPlant {
    private static final DataParameter<Integer> SUPER_TIME = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PLANT_LVL = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> PLANT_STATES = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ATTACK_TIME = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GOLD_TIME = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> PUMPKIN_LIFE = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> EXIST_TICK = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final int PLANT_LEVEL_FLAG_LEN = 7;
    private static final int PLANT_LEVEL_SYNC_CD = 1200;
    public boolean need_sync_level = true;
    protected static final int LADDER_FLAG = 0;
    protected static final int CHARM_FLAG = 1;
    protected static final int SLEEP_FLAG = 2;
    private static final int PLANT_WEAK_CD = 10;
    protected PlayerEntity ownerPlayer;
    protected boolean isImmuneToWeak = false;
    protected int weakTime = 0;
    public boolean canCollideWithPlant = true;
    public int sleepTime = 0;
    protected Optional<Plants> outerPlant = Optional.empty();
    public int outerSunCost = 0;
    public int plantSunCost = 0;
    protected boolean canBeCold = true;
    protected boolean canBeFrozen = true;
    protected boolean canBeCharm = true;
    protected boolean canBeButter = true;
    protected boolean canBeRemove = true;
    protected boolean canHelpAttack = true;

    public PVZPlantEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_213323_x_();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUPER_TIME, (Object)0);
        this.field_70180_af.func_187214_a(PLANT_LVL, (Object)1);
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(ATTACK_TIME, (Object)0);
        this.field_70180_af.func_187214_a(GOLD_TIME, (Object)0);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
        this.field_70180_af.func_187214_a(PUMPKIN_LIFE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PLANT_STATES, (Object)0);
        this.field_70180_af.func_187214_a(EXIST_TICK, (Object)0);
    }

    public static AttributeModifierMap createPlantAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233813_a_();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new PVZLookRandomlyGoal((MobEntity)this));
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!worldIn.func_201670_d()) {
            EntityUtil.playSound((Entity)this, this.getSpawnSound());
            this.updateAttributes();
            this.func_70691_i(this.func_110138_aP());
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void updateAttributes() {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.getPlantHealth());
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70170_p.func_217381_Z().func_76320_a("PVZ Plant Tick");
        this.plantTick();
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (this.canPlantNormalUpdate()) {
            this.field_70170_p.func_217381_Z().func_76320_a("PVZ Normal Plant Tick");
            this.normalPlantTick();
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
    }

    public boolean canPlantNormalUpdate() {
        if (!EntityUtil.isEntityValid((Entity)this)) {
            return false;
        }
        if (this.func_184187_bx() instanceof BungeeZombieEntity || this.hasMetal()) {
            return false;
        }
        return !this.isPlantSleeping() && !EntityUtil.isEntityFrozen((LivingEntity)this) && !EntityUtil.isEntityButter((LivingEntity)this);
    }

    protected void plantTick() {
        if (!this.field_70170_p.field_72995_K && !this.isImmuneToWeak && this.func_184187_bx() == null) {
            if (this.checkNormalPlantWeak() && this.weakTime <= 0) {
                this.weakTime = 10;
                this.func_70097_a(PVZDamageSource.PLANT_WILT, EntityUtil.getMaxHealthDamage((LivingEntity)this, 0.5f));
            }
            this.weakTime = Math.max(0, this.weakTime - 1);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setSuperTime(Math.max(0, this.getSuperTime() - 1));
            this.setBoostTime(Math.max(0, this.getBoostTime() - 1));
            this.setExistTick(this.getExistTick() + 1);
            if (this.shouldPlantRegularSleep()) {
                this.sleepTime = this.sleepTime <= 1 ? this.sleepTime + 1 : this.sleepTime - 1;
            } else {
                int n = this.sleepTime = this.sleepTime <= -1 ? this.sleepTime + 1 : this.sleepTime - 1;
            }
            if (!this.isPlantSleeping() && this.sleepTime > 0) {
                this.setPlantSleeping(true);
            }
            if (this.isPlantSleeping() && this.sleepTime <= 0) {
                this.setPlantSleeping(false);
            }
        }
        if (this.field_70170_p.field_72995_K && this.isPlantSleeping() && this.field_70173_aa % 20 == 0) {
            EntityUtil.spawnSpeedParticle((Entity)this, (IParticleData)ParticleRegister.SLEEP.get(), 0.05f);
        }
        if (this.shouldLockXZ() && this.func_184187_bx() == null) {
            BlockPos pos = this.func_233580_cy_();
            this.func_70107_b((double)pos.func_177958_n() + 0.5, this.func_226278_cu_(), (double)pos.func_177952_p() + 0.5);
        }
        if (!this.field_70170_p.field_72995_K && this.getPlantEnumName().isWaterPlant && this.func_70090_H()) {
            Vector3d vec = this.func_213322_ci();
            double speedY = Math.min(vec.field_72448_b, 0.05);
            this.func_213293_j(vec.field_72450_a, speedY, vec.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K && this.need_sync_level && this.getExistTick() % 1200 == 5) {
            this.getOwnerPlayer().ifPresent(player -> player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> this.updatePlantLevel(l.getPlayerData().getPlantStats().getPlantLevel(this.getPlantEnumName()))));
        }
    }

    protected void normalPlantTick() {
        if (!this.field_70170_p.field_72995_K && this.getGoldTime() < 400) {
            Block block = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_177230_c();
            int lvl = GoldLeafEntity.getBlockGoldLevel(block);
            if (lvl <= 0) {
                return;
            }
            this.setGoldTime(this.getGoldTime() + 1);
            if (this.getGoldTime() >= 400) {
                this.setGoldTime(0);
                SunEntity sun = (SunEntity)((EntityType)EntityRegister.SUN.get()).func_200721_a(this.field_70170_p);
                sun.setAmount(GoldLeafEntity.getGoldGenAmount(lvl));
                EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, sun, this.func_233580_cy_(), 2);
                EntityUtil.playSound((Entity)this, SoundEvents.field_187604_bf);
            }
        }
    }

    protected boolean checkNormalPlantWeak() {
        double y2;
        if (this.isImmuneToWeak || this.func_184187_bx() != null) {
            return false;
        }
        if (this.getPlantEnumName().isWaterPlant) {
            return this.field_70122_E && !this.func_70090_H() && this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c() != Blocks.field_150355_j;
        }
        if (!this.field_70122_E) {
            return false;
        }
        if (this.func_203005_aq()) {
            return true;
        }
        double y1 = this.func_226278_cu_();
        BlockPos pos = Math.abs(y1 - (y2 = (double)MathHelper.func_76128_c((double)y1))) <= 0.01 ? this.func_233580_cy_().func_177977_b() : this.func_233580_cy_();
        Block current = this.field_70170_p.func_180495_p(pos).func_177230_c();
        return !PlantUtil.getPlantSuitBlock(this.getPlantEnumName()).stream().anyMatch(block -> block.func_235332_a_(current));
    }

    public void onSpawnedByPlayer(PlayerEntity player, int lvl) {
        this.setOwnerUUID(player.func_110124_au());
        this.updatePlantLevel(lvl);
    }

    public void updatePlantLevel(int lvl) {
        if (this.getPlantLvl() != lvl) {
            this.setPlantLvl(lvl);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.getPlantHealth());
            this.func_70691_i(this.func_110138_aP());
        }
    }

    public boolean checkCanPlantTarget(Entity target) {
        return EntityUtil.checkCanEntityBeTarget((Entity)this, target) && this.canPlantTarget(target);
    }

    public boolean checkCanPlantAttack(Entity entity) {
        return EntityUtil.checkCanEntityBeAttack((Entity)this, entity) && this.canPlantTarget(entity);
    }

    public boolean canBeTargetBy(LivingEntity living) {
        return !this.hasMetal();
    }

    public boolean canPlantTarget(Entity target) {
        if (target instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)target).canBeTargetBy((LivingEntity)this);
        }
        if (target instanceof PVZPlantEntity) {
            return ((PVZPlantEntity)target).canBeTargetBy((LivingEntity)this);
        }
        return true;
    }

    protected boolean shouldPlantRegularSleep() {
        if (this.getPlantEnumName().isShroomPlant) {
            return this.field_70170_p.func_72935_r();
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (source instanceof PVZDamageSource) {
            this.field_70172_ad = 0;
        }
        amount = this.pumpkinReduceDamage(source, amount);
        return super.func_70097_a(source, amount);
    }

    protected float pumpkinReduceDamage(DamageSource source, float amount) {
        if (source instanceof PVZDamageSource && ((PVZDamageSource)source).isParabola()) {
            return amount;
        }
        if (this.outerPlant.isPresent() && this.outerPlant.get() == Plants.PUMPKIN) {
            if (this.getPumpkinLife() > amount) {
                this.setPumpkinLife(this.getPumpkinLife() - amount);
                amount = 0.0f;
            } else {
                amount -= this.getPumpkinLife();
                this.setPumpkinLife(0.0f);
                this.outerPlant = Optional.empty();
            }
        }
        return amount;
    }

    public void checkAndAddPotionEffect(EffectInstance effect) {
        if (effect.func_188419_a() == EffectRegister.COLD_EFFECT.get() && !this.canBeCold()) {
            return;
        }
        if (effect.func_188419_a() == EffectRegister.FROZEN_EFFECT.get() && !this.canBeFrozen()) {
            return;
        }
        if (effect.func_188419_a() == EffectRegister.BUTTER_EFFECT.get() && !this.canBeButter()) {
            return;
        }
        this.func_195064_c(effect);
    }

    public static void clearLadders(LivingEntity entity, AxisAlignedBB aabb) {
        entity.field_70170_p.func_175647_a(PVZPlantEntity.class, aabb, target -> target.hasMetal() && !EntityUtil.checkCanEntityBeAttack((Entity)entity, (Entity)target)).forEach(plant -> plant.setMetal(false));
    }

    public boolean func_70652_k(Entity entityIn) {
        entityIn.field_70172_ad = 0;
        return super.func_70652_k(entityIn);
    }

    protected boolean shouldLockXZ() {
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        if (!(this.func_184223_x(entityIn) || entityIn.field_70145_X || this.field_70145_X)) {
            double d1;
            double d0 = entityIn.func_226277_ct_() - this.func_226277_ct_();
            double d2 = MathHelper.func_76132_a((double)d0, (double)(d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()));
            if (d2 >= (double)0.01f) {
                d2 = MathHelper.func_76133_a((double)d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                d0 *= (double)(1.0f - this.field_70144_Y);
                d1 *= (double)(1.0f - this.field_70144_Y);
                if (!entityIn.func_184207_aI()) {
                    entityIn.func_70024_g(d0, 0.0, d1);
                }
            } else if (this instanceof PVZPlantEntity && entityIn instanceof PVZPlantEntity && !EntityUtil.canTargetEntity((Entity)this, entityIn) && this.field_70173_aa >= entityIn.field_70173_aa) {
                this.func_70097_a(PVZDamageSource.PLANT_WILT, EntityUtil.getMaxHealthDamage((LivingEntity)this, 0.5f));
            }
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ());
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_223592_c(GameRules.field_223616_s);
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (((Entity)list.get(k)).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                LivingEntity target = (LivingEntity)list.get(l);
                if (this.func_70028_i((Entity)target) || !this.shouldCollideWithEntity(target)) continue;
                this.func_82167_n((Entity)target);
            }
        }
    }

    protected boolean shouldCollideWithEntity(LivingEntity target) {
        if (target instanceof PVZPlantEntity) {
            if (!this.canCollideWithPlant || !((PVZPlantEntity)target).canCollideWithPlant) {
                return false;
            }
            if (target instanceof SquashEntity) {
                return !EntityUtil.canTargetEntity((Entity)this, (Entity)target);
            }
            if (target instanceof SpikeWeedEntity) {
                return !EntityUtil.canTargetEntity((Entity)this, (Entity)target);
            }
            return true;
        }
        if (target instanceof MobEntity) {
            if (((MobEntity)target).func_70638_az() == this) {
                return true;
            }
            if (target instanceof TombStoneEntity) {
                return true;
            }
        }
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isPlantImmuneTo(source) && source != DamageSource.field_76380_i && !source.func_180136_u() && !source.equals((Object)PVZDamageSource.PLANT_WILT);
    }

    public boolean isPlantImmuneTo(DamageSource source) {
        return this.isPlantInSuperMode();
    }

    public boolean func_70648_aU() {
        return this.getPlantEnumName().isWaterPlant;
    }

    public boolean canHelpAttack() {
        return this.canHelpAttack;
    }

    @Override
    public float getPlantHealth() {
        int lvl = this.getPlantLvl();
        if (lvl <= 14) {
            return 27.5f + 2.5f * (float)lvl;
        }
        if (lvl <= 20) {
            return 5 * lvl - 10;
        }
        return 100.0f;
    }

    @Nullable
    public Plants getUpgradePlantType() {
        return null;
    }

    @Override
    public void onCharmedBy(LivingEntity entity) {
        if (!this.canBeCharmed()) {
            return;
        }
        this.setCharmed(!this.isCharmed());
    }

    public void startSuperMode(boolean first) {
        this.setSuperTime(this.getSuperTimeLength());
        this.func_70691_i(this.func_110138_aP());
        if (first) {
            PlayerEntity player = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)this);
            if (player != null && player instanceof ServerPlayerEntity) {
                PlantSuperTrigger.INSTANCE.trigger((ServerPlayerEntity)player, (Entity)this);
                PlayerUtil.addPlantXp(player, this.getPlantEnumName(), 2);
            }
            this.outerPlant.ifPresent(plant -> {
                if (plant == Plants.PUMPKIN) {
                    this.setPumpkinLife(800.0f);
                }
            });
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.getOwnerUUID().isPresent();
    }

    public void removeOuterPlant() {
        this.outerPlant = Optional.empty();
        this.setPumpkinLife(0.0f);
        this.outerSunCost = 0;
        if (this.hasMetal()) {
            this.decreaseMetal();
        }
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec3d, Hand hand) {
        ItemStack stack;
        if (!this.field_70170_p.field_72995_K && (stack = player.func_184586_b(hand)).func_77973_b() instanceof PlantCardItem) {
            PlantCardItem item = (PlantCardItem)stack.func_77973_b();
            if (!this.getPlantEnumName().isBigPlant && item.plantType == Plants.PUMPKIN) {
                if (this.outerPlant.isPresent() && this.outerPlant.get() == Plants.PUMPKIN) {
                    if (this.getPumpkinLife() < 400.0f) {
                        PlantCardItem.checkSunAndHealPlant(player, this, item, stack);
                    }
                } else {
                    PlantCardItem.checkSunAndOuterPlant(player, this, item, stack);
                }
            } else if (!this.getPlantEnumName().isBigPlant && item instanceof ImitaterCardItem && ((ImitaterCardItem)item).isPlantTypeEqual(stack, Plants.PUMPKIN)) {
                if (this.outerPlant.isPresent() && this.outerPlant.get() == Plants.PUMPKIN) {
                    if (this.getPumpkinLife() < 400.0f) {
                        PlantCardItem.checkSunAndHealPlant(player, this, item, stack);
                    }
                } else {
                    PlantCardItem.checkSunAndOuterPlant(player, this, item, stack);
                }
            } else if (item.plantType == Plants.COFFEE_BEAN) {
                PlantCardItem.checkSunAndSummonPlant(player, stack, item, this.func_233580_cy_(), plantEntity -> plantEntity.func_184220_m((Entity)this));
            } else if (item instanceof ImitaterCardItem && ((ImitaterCardItem)item).isPlantTypeEqual(stack, Plants.COFFEE_BEAN)) {
                ImitaterCardItem.checkSunAndSummonImitater(player, stack, item, this.func_233580_cy_(), imitater -> imitater.func_184220_m((Entity)this));
            } else if (this.getUpgradePlantType() == item.plantType) {
                PlantCardItem.checkSunAndSummonPlant(player, stack, item, this.func_233580_cy_(), plantEntity -> this.onPlantUpgrade((PVZPlantEntity)plantEntity));
            } else if (item instanceof ImitaterCardItem && ((ImitaterCardItem)item).isPlantTypeEqual(stack, this.getUpgradePlantType())) {
                ImitaterCardItem.checkSunAndSummonImitater(player, stack, item, this.func_233580_cy_(), imitater -> {
                    imitater.targetPlantEntity = Optional.of(this);
                });
            }
        }
        return ActionResultType.SUCCESS;
    }

    protected void onPlantUpgrade(PVZPlantEntity plantEntity) {
        if (!plantEntity.getPlantEnumName().isBigPlant) {
            plantEntity.setPumpkinLife(this.getPumpkinLife());
            this.getOuterPlantType().ifPresent(plantType -> plantEntity.setOuterPlantType((Plants)((Object)plantType)));
            plantEntity.outerSunCost = this.outerSunCost;
        }
        plantEntity.plantSunCost += this.plantSunCost;
        plantEntity.sleepTime = this.sleepTime;
        this.func_70106_y();
    }

    public boolean canBeButter() {
        return this.canBeButter;
    }

    public boolean canBeCharmed() {
        return this.canBeCharm;
    }

    public boolean canBeFrozen() {
        return this.canBeFrozen && !this.func_203005_aq() && !this.func_180799_ab();
    }

    public boolean canBeCold() {
        return this.canBeCold;
    }

    public boolean isPlantInSuperMode() {
        return this.getSuperTime() > 0;
    }

    private boolean hasSuperMode() {
        return this.getSuperTimeLength() > 0;
    }

    public boolean isPlantInBoost() {
        return this.getBoostTime() > 0;
    }

    @Override
    public int getCoolDownTime() {
        return PlantUtil.getPlantCoolDownTime(this.getPlantEnumName(), this.getPlantLvl());
    }

    @Override
    public int getSunCost() {
        return PlantUtil.getPlantSunCost(this.getPlantEnumName());
    }

    @Override
    public Essences getPlantEssenceType() {
        return PlantUtil.getPlantEssenceType(this.getPlantEnumName());
    }

    @Override
    public Ranks getPlantRank(Plants plant) {
        return PlantUtil.getPlantRankByName(plant);
    }

    protected float getCurrentDefenceHealth() {
        return this.getPumpkinLife();
    }

    @Override
    public float getCurrentHealth() {
        return this.func_110143_aJ() + this.getCurrentDefenceHealth();
    }

    @Override
    public float getCurrentMaxHealth() {
        return this.func_110138_aP() + this.getCurrentDefenceHealth();
    }

    protected boolean isPlantInStage(int stage) {
        int lvl = this.getPlantLvl();
        if (stage == 1) {
            return lvl <= 6;
        }
        if (stage == 2) {
            return 7 <= lvl && lvl <= 13;
        }
        if (stage == 3) {
            return 14 <= lvl && lvl <= 20;
        }
        return false;
    }

    public int getThreeStage(int a, int b, int c) {
        return this.isPlantInStage(1) ? a : (this.isPlantInStage(2) ? b : c);
    }

    public int getAverageProgress(int a, int b) {
        return PlantUtil.getPlantAverageProgress(this, a, b);
    }

    public float getAverageProgress(float a, float b) {
        return PlantUtil.getPlantAverageProgress(this, a, b);
    }

    public boolean canStartSuperMode() {
        return this.canPlantNormalUpdate() && this.hasSuperMode() && !this.isPlantInSuperMode();
    }

    public Optional<PlayerEntity> getOwnerPlayer() {
        if (!this.hasOwner()) {
            return Optional.empty();
        }
        if (!EntityUtil.isEntityValid((Entity)this.ownerPlayer)) {
            this.ownerPlayer = this.field_70170_p.func_217371_b(this.getOwnerUUID().get());
        }
        return Optional.ofNullable(this.ownerPlayer);
    }

    @Override
    public PVZGroupType getEntityGroupType() {
        return this.isCharmed() ? PVZGroupType.ZOMBIES : PVZGroupType.PLANTS;
    }

    public boolean hasOwner() {
        return this.getOwnerUUID().isPresent();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("plant_super_time", this.getSuperTime());
        compound.func_74768_a("plant_lvl", this.getPlantLvl());
        if (this.getOwnerUUID().isPresent()) {
            compound.func_186854_a("OwnerUUID", this.getOwnerUUID().get());
        }
        compound.func_74768_a("plant_attack_time", this.getAttackTime());
        compound.func_74768_a("plant_gold_time", this.getGoldTime());
        compound.func_74768_a("plant_boost_time", this.getBoostTime());
        compound.func_74768_a("plant_sleep_time", this.sleepTime);
        this.outerPlant.ifPresent(plant -> compound.func_74768_a("outer_plant_type", plant.ordinal()));
        compound.func_74776_a("pumpkin_life", this.getPumpkinLife());
        compound.func_74768_a("plant_sun_cost", this.plantSunCost);
        compound.func_74768_a("outer_sun_cost", this.outerSunCost);
        compound.func_74757_a("immune_to_weak", this.isImmuneToWeak);
        compound.func_74768_a("plant_state", this.getPlantState());
        compound.func_74768_a("plant_exist_tick", this.getExistTick());
    }

    public void func_70037_a(CompoundNBT compound) {
        UUID uuid;
        super.func_70037_a(compound);
        if (compound.func_74764_b("plant_super_time")) {
            this.setSuperTime(compound.func_74762_e("plant_super_time"));
        }
        if (compound.func_74764_b("plant_lvl")) {
            this.setPlantLvl(compound.func_74762_e("plant_lvl"));
        }
        if (compound.func_186855_b("OwnerUUID")) {
            uuid = compound.func_186857_a("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("OwnerUUID");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (compound.func_74764_b("plant_attack_time")) {
            this.setAttackTime(compound.func_74762_e("plant_attack_time"));
        }
        if (compound.func_74764_b("plant_gold_time")) {
            this.setGoldTime(compound.func_74762_e("plant_gold_time"));
        }
        if (compound.func_74764_b("plant_boost_time")) {
            this.setBoostTime(compound.func_74762_e("plant_boost_time"));
        }
        if (compound.func_74764_b("plant_sleep_time")) {
            this.sleepTime = compound.func_74762_e("plant_sleep_time");
        }
        if (compound.func_74764_b("pumpkin_life")) {
            this.setPumpkinLife(compound.func_74760_g("pumpkin_life"));
        }
        if (compound.func_74764_b("outer_plant_type")) {
            this.outerPlant = Optional.of(Plants.values()[compound.func_74762_e("outer_plant_type")]);
        }
        if (compound.func_74764_b("plant_sun_cost")) {
            this.plantSunCost = compound.func_74762_e("plant_sun_cost");
        }
        if (compound.func_74764_b("outer_sun_cost")) {
            this.outerSunCost = compound.func_74762_e("outer_sun_cost");
        }
        if (compound.func_74764_b("immune_to_weak")) {
            this.isImmuneToWeak = compound.func_74767_n("immune_to_weak");
        }
        if (compound.func_74764_b("plant_state")) {
            this.setPlantState(compound.func_74762_e("plant_state"));
        }
        if (compound.func_74764_b("plant_exist_tick")) {
            this.setExistTick(compound.func_74762_e("plant_exist_tick"));
        }
    }

    public void setOuterPlantType(Plants p) {
        this.outerPlant = Optional.of(p);
    }

    public Optional<Plants> getOuterPlantType() {
        return this.outerPlant;
    }

    public void setImmunneToWeak(boolean is) {
        this.isImmuneToWeak = is;
    }

    public int getBoostTime() {
        return (Integer)this.field_70180_af.func_187225_a(BOOST_TIME);
    }

    public void setBoostTime(int time) {
        this.field_70180_af.func_187227_b(BOOST_TIME, (Object)time);
    }

    public int getGoldTime() {
        return (Integer)this.field_70180_af.func_187225_a(GOLD_TIME);
    }

    public void setGoldTime(int cd) {
        this.field_70180_af.func_187227_b(GOLD_TIME, (Object)cd);
    }

    public int getAttackTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TIME);
    }

    public void setAttackTime(int cd) {
        this.field_70180_af.func_187227_b(ATTACK_TIME, (Object)cd);
    }

    public void setPlantLvl(int lvl) {
        this.field_70180_af.func_187227_b(PLANT_LVL, (Object)lvl);
    }

    public int getPlantLvl() {
        return (Integer)this.field_70180_af.func_187225_a(PLANT_LVL);
    }

    @Override
    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.field_70180_af.func_187225_a(OWNER_UUID);
    }

    public void setOwnerUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setSuperTime(int time) {
        this.field_70180_af.func_187227_b(SUPER_TIME, (Object)time);
    }

    public int getSuperTime() {
        return (Integer)this.field_70180_af.func_187225_a(SUPER_TIME);
    }

    public float getPumpkinLife() {
        return ((Float)this.field_70180_af.func_187225_a(PUMPKIN_LIFE)).floatValue();
    }

    public void setPumpkinLife(float life) {
        this.field_70180_af.func_187227_b(PUMPKIN_LIFE, (Object)Float.valueOf(life));
    }

    public int getExistTick() {
        return (Integer)this.field_70180_af.func_187225_a(EXIST_TICK);
    }

    public void setExistTick(int tick) {
        this.field_70180_af.func_187227_b(EXIST_TICK, (Object)tick);
    }

    public int getPlantState() {
        return (Integer)this.field_70180_af.func_187225_a(PLANT_STATES);
    }

    public void setPlantState(int state) {
        this.field_70180_af.func_187227_b(PLANT_STATES, (Object)state);
    }

    @Override
    public boolean hasMetal() {
        return AlgorithmUtil.BitOperator.hasBitOne(this.getPlantState(), 0);
    }

    public void setMetal(boolean flag) {
        this.setPlantState(AlgorithmUtil.BitOperator.setBit(this.getPlantState(), 0, flag));
    }

    @Override
    public boolean isCharmed() {
        return AlgorithmUtil.BitOperator.hasBitOne(this.getPlantState(), 1);
    }

    public void setCharmed(boolean flag) {
        this.setPlantState(AlgorithmUtil.BitOperator.setBit(this.getPlantState(), 1, flag));
    }

    public boolean isPlantSleeping() {
        return AlgorithmUtil.BitOperator.hasBitOne(this.getPlantState(), 2);
    }

    public void setPlantSleeping(boolean flag) {
        this.setPlantState(AlgorithmUtil.BitOperator.setBit(this.getPlantState(), 2, flag));
    }

    @Override
    public void increaseMetal() {
        this.setMetal(true);
    }

    @Override
    public void decreaseMetal() {
        this.setMetal(false);
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.LADDER;
    }

    protected SoundEvent getSpawnSound() {
        return this.getPlantEnumName().isWaterPlant ? (SoundEvent)SoundRegister.PLANT_IN_WATER.get() : (SoundEvent)SoundRegister.PLANT_ON_GROUND.get();
    }
}

