/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.appease;

import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.bullet.StarEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class AngelStarFruitEntity
extends PlantShooterEntity {
    public static final float PER_ANGLE = 72.0f;
    private static final float SHOOT_HEIGHT = 0.2f;
    public int lightTick = 0;

    public AngelStarFruitEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void normalPlantTick() {
        if (this.field_70170_p.field_72995_K) {
            if (this.lightTick > 0) {
                --this.lightTick;
            }
            if (this.getAttackTime() > 0) {
                this.lightTick = 8;
            }
        }
        super.normalPlantTick();
        if (this.isPlantInSuperMode()) {
            float now = this.getSuperTime() * 4;
            for (int i = 0; i < 5; ++i) {
                this.shootByAngle(now, 0.2f);
                now += 72.0f;
            }
        }
    }

    @Override
    public void shootBullet() {
        int i;
        float now = this.field_70759_as;
        for (i = 0; i < 5; ++i) {
            this.shootByAngle(now, 0.2f);
            now += 72.0f;
        }
        if (this.func_70681_au().nextInt(100) < this.getExtraAttackChance()) {
            now = this.field_70759_as + 36.0f;
            for (i = 0; i < 5; ++i) {
                this.shootByAngle(now, 0.2f);
                now += 72.0f;
            }
        }
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.SNOW_SHOOT.get());
    }

    public int getExtraAttackChance() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 20, 80);
    }

    @Override
    public float getAttackDamage() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 2.0f, 8.0f);
    }

    @Override
    protected boolean canAttackNow() {
        return this.getAttackTime() == 2 && !this.isPlantInSuperMode();
    }

    @Override
    protected AbstractBulletEntity createBullet() {
        StarEntity.StarTypes type = this.isPlantInSuperMode() ? StarEntity.StarTypes.BIG : StarEntity.StarTypes.NORMAL;
        return new StarEntity(this.field_70170_p, (LivingEntity)this, type, StarEntity.StarStates.PINK);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.9f, (float)0.5f);
    }

    @Override
    public double getMaxShootAngle() {
        return 80.0;
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(2);
    }

    @Override
    public int getSuperTimeLength() {
        return this.isPlantInStage(1) ? 100 : (this.isPlantInStage(2) ? 200 : 300);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.ANGEL_STAR_FRUIT;
    }
}

