/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.appease;

import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.bullet.itembullet.PeaEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.world.World;

public class PeaShooterEntity
extends PlantShooterEntity {
    protected static final double SHOOT_OFFSET = 0.2;

    public PeaShooterEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void shootBullet() {
        if (this.isPlantInSuperMode()) {
            int cnt = this.getSuperShootCount();
            for (int i = 0; i < cnt; ++i) {
                float offset = MathUtil.getRandomFloat(this.func_70681_au()) / 3.0f;
                float offsetH = MathUtil.getRandomFloat(this.func_70681_au()) / 3.0f;
                this.performShoot(0.2, offset, offsetH, this.getExistTick() % 10 == 0, 0.0);
            }
        } else {
            this.performShoot(0.2, 0.0, 0.0, this.getAttackTime() == 1, 0.0);
        }
    }

    @Override
    protected AbstractBulletEntity createBullet() {
        return new PeaEntity(this.field_70170_p, (LivingEntity)this, this.getShootType(), this.getShootState());
    }

    public int getSuperShootCount() {
        int min = this.isPlantInStage(3) ? 2 : 1;
        int max = this.isPlantInStage(1) ? 2 : 3;
        return MathUtil.getRandomMinMax(this.func_70681_au(), min, max);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.5f);
    }

    protected PeaEntity.Type getShootType() {
        return PeaEntity.Type.NORMAL;
    }

    protected PeaEntity.State getShootState() {
        return PeaEntity.State.NORMAL;
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(1);
    }

    @Override
    public int getSuperTimeLength() {
        return 100;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.PEA_SHOOTER;
    }
}

