/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.appease;

import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.appease.PeaShooterEntity;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;

public class SplitPeaEntity
extends PeaShooterEntity {
    private static final DataParameter<Integer> ROUND_TICK = EntityDataManager.func_187226_a(SplitPeaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int MAX_ROUND_TIME = 20;

    public SplitPeaEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ROUND_TICK, (Object)0);
    }

    @Override
    protected void plantTick() {
        super.plantTick();
        if (!this.field_70170_p.field_72995_K && this.getRoundTick() != 0 && this.getRoundTick() != 10) {
            this.rotateFacing();
        }
    }

    @Override
    public void shootBullet() {
        if (this.isPlantInSuperMode()) {
            int cnt = this.getSuperShootCount();
            for (int i = 0; i < cnt; ++i) {
                float offset = MathUtil.getRandomFloat(this.func_70681_au()) / 3.0f;
                float offsetH = MathUtil.getRandomFloat(this.func_70681_au()) / 3.0f;
                this.performShoot(0.2, offset, offsetH, this.getExistTick() % 10 == 0, 0.0);
                this.performShoot(0.2, offset, offsetH, false, 180.0);
            }
        } else {
            int backNum;
            int frontNum = this.isFacingFront() ? 1 : 2;
            int n = backNum = this.isFacingFront() ? 2 : 1;
            if (this.getAttackTime() <= frontNum) {
                this.performShoot(0.2, 0.0, 0.0, this.getAttackTime() == 1, 0.0);
            }
            if (this.getAttackTime() <= backNum) {
                this.performShoot(0.2, 0.0, 0.0, false, 180.0);
            }
            this.checkAndChangeFacing();
        }
    }

    private void checkAndChangeFacing() {
        if (this.getAttackTime() == 1 && !this.isPlantInSuperMode()) {
            int chance;
            int n = chance = this.isFacingFront() ? this.getDoubleChance() : 100 - this.getDoubleChance();
            if (this.func_70681_au().nextInt(100) < chance) {
                this.rotateFacing();
            }
        }
    }

    private void rotateFacing() {
        this.setRoundTick((this.getRoundTick() + 1) % 20);
    }

    public int getDoubleChance() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 20, 80);
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(2);
    }

    public boolean isFacingFront() {
        return this.getRoundTick() == 0;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("round_tick")) {
            this.setRoundTick(compound.func_74762_e("round_tick"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("round_tick", this.getRoundTick());
    }

    public int getRoundTick() {
        return (Integer)this.field_70180_af.func_187225_a(ROUND_TICK);
    }

    public void setRoundTick(int tick) {
        this.field_70180_af.func_187227_b(ROUND_TICK, (Object)tick);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SPLIT_PEA;
    }
}

