/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.appease;

import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.bullet.StarEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class StarFruitEntity
extends PlantShooterEntity {
    public static final float PER_ANGLE = 72.0f;
    private static final float SHOOT_HEIGHT = 0.2f;
    public int lightTick = 0;

    public StarFruitEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void normalPlantTick() {
        if (this.field_70170_p.field_72995_K) {
            if (this.lightTick > 0) {
                --this.lightTick;
            }
            if (this.getAttackTime() > 0) {
                this.lightTick = 8;
            }
        }
        super.normalPlantTick();
    }

    @Override
    protected boolean canAttackNow() {
        return this.getAttackTime() == 2;
    }

    @Override
    public int getSuperTimeLength() {
        return this.isPlantInStage(1) ? 100 : (this.isPlantInStage(2) ? 150 : 200);
    }

    @Override
    public void shootBullet() {
        float now = this.field_70177_z + 180.0f;
        for (int i = 0; i < 5; ++i) {
            this.shootByAngle(now, 0.2f);
            now += 72.0f;
        }
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.SNOW_SHOOT.get());
    }

    @Override
    protected AbstractBulletEntity createBullet() {
        StarEntity.StarTypes type = this.isPlantInSuperMode() ? StarEntity.StarTypes.HUGE : StarEntity.StarTypes.NORMAL;
        return new StarEntity(this.field_70170_p, (LivingEntity)this, type, StarEntity.StarStates.YELLOW);
    }

    @Override
    public float getAttackDamage() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 2.0f, 6.0f);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.9f, (float)0.5f);
    }

    @Override
    public double getMaxShootAngle() {
        return 80.0;
    }

    @Override
    public void startShootAttack() {
        this.updateFacing();
        this.setAttackTime(2);
    }

    private void updateFacing() {
        float now = this.func_70681_au().nextFloat() * 3.14159f * 2.0f;
        double dx = Math.sin(now);
        double dz = Math.cos(now);
        double dy = 0.0;
        this.func_200602_a(EntityAnchorArgument.Type.FEET, this.func_213303_ch().func_72441_c(dx, dy, dz));
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.STAR_FRUIT;
    }
}

